/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.service.impl;

import java.util.List;
import org.tinygroup.context.Context;
import org.tinygroup.event.Parameter;
import org.tinygroup.i18n.I18nMessageFactory;
import org.tinygroup.i18n.I18nMessages;
import org.tinygroup.service.Service;
import org.tinygroup.service.ServiceProviderInterface;
import org.tinygroup.service.exception.ParameterCheckFailException;
import org.tinygroup.service.exception.ServiceNotExistException;
import org.tinygroup.service.registry.ServiceRegistry;
import org.tinygroup.service.registry.ServiceRegistryItem;

public class ServiceProviderImpl
implements ServiceProviderInterface {
    private static final String OUTPUT = "\u8f93\u51fa";
    private static final String INPUT = "\u8f93\u5165";
    private ServiceRegistry serviceRegistory = null;
    private I18nMessages i18nMessages = I18nMessageFactory.getI18nMessages();

    @Override
    public ServiceRegistry getServiceRegistory() {
        return this.serviceRegistory;
    }

    @Override
    public void setServiceRegistory(ServiceRegistry serviceRegistory) {
        this.serviceRegistory = serviceRegistory;
    }

    @Override
    public void validateInputParameter(Service service, Context Context2) {
        ServiceRegistryItem serviceRegistryItem = this.serviceRegistory.getServiceRegistryItem(service);
        this.validateParameter(serviceRegistryItem.getParameters(), Context2, INPUT);
    }

    private void validateParameter(List<Parameter> parameterDescriptors, Context context, String direct) {
        if (parameterDescriptors != null) {
            for (Parameter parameterDescriptor : parameterDescriptors) {
                Object object = context.get(parameterDescriptor.getName());
                if (parameterDescriptor.isRequired() && object == null) {
                    throw new ParameterCheckFailException(this.i18nMessages.getMessage("service.paramIsNotExist", parameterDescriptor.getName(), new Object[0]));
                }
                if (object.getClass().isArray() != parameterDescriptor.isArray()) {
                    throw new ParameterCheckFailException(this.i18nMessages.getMessage("service.paramArrayNotSuit", parameterDescriptor.getName(), new Object[]{parameterDescriptor.isArray(), object.getClass().isArray()}));
                }
                if (object.getClass().getName().equals(parameterDescriptor.getType())) continue;
                throw new ParameterCheckFailException(this.i18nMessages.getMessage("service.paramNotSuit", parameterDescriptor.getName(), new Object[]{object.getClass().getClass().getName(), parameterDescriptor.getType()}));
            }
        }
    }

    @Override
    public void validateOutputParameter(Service service, Context context) {
        ServiceRegistryItem serviceRegistryItem = this.serviceRegistory.getServiceRegistryItem(service);
        this.validateParameter(serviceRegistryItem.getResults(), context, OUTPUT);
    }

    @Override
    public void execute(Service service, Context context) {
        service.execute(context);
    }

    @Override
    public void execute(String serviceId, Context context) {
        ServiceRegistryItem serviceRegistryItem = this.serviceRegistory.getServiceRegistryItem(serviceId);
        if (serviceRegistryItem == null) {
            throw new ServiceNotExistException();
        }
        serviceRegistryItem.getService().execute(context);
    }

    @Override
    public <T> void setConfig(T config) {
    }

    @Override
    public Service getService(String serviceId) {
        ServiceRegistryItem item = this.serviceRegistory.getServiceRegistryItem(serviceId);
        if (item == null) {
            return null;
        }
        return item.getService();
    }

    @Override
    public ServiceRegistryItem getServiceRegistryItem(Service service) {
        return this.serviceRegistory.getServiceRegistryItem(service);
    }
}

