/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.service.release.fileresolver;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import org.tinygroup.fileresolver.FileProcessor;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.service.release.ServiceReleaseManager;
import org.tinygroup.service.release.config.ServiceRelease;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class ServiceReleaseProcessor
extends AbstractFileProcessor
implements FileProcessor {
    private static final String SERVICE_RELEASE_EXTENSION = ".servicerelease.xml";

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)"service");
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u8bfb\u53d6servicerelease\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            try {
                InputStream inputStream = fileObject.getInputStream();
                ServiceRelease filter = (ServiceRelease)stream.fromXML(inputStream);
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    LOGGER.errorMessage("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u51fa\u9519,\u6587\u4ef6\u8def\u5f84:{}", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
                }
                try {
                    LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7dservicerelease");
                    ServiceReleaseManager.add(filter);
                    LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7dservicerelease\u7ed3\u675f");
                }
                catch (Exception e) {
                    LOGGER.errorMessage("\u52a0\u8f7dservicerelease\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e, new Object[0]);
                }
            }
            catch (Exception e) {
                LOGGER.errorMessage("\u52a0\u8f7dservicerelease\u6587\u4ef6[{0}]\u51fa\u73b0\u5f02\u5e38", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
            }
            LOGGER.logMessage(LogLevel.INFO, "\u8bfb\u53d6servicerelease\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(SERVICE_RELEASE_EXTENSION);
    }
}

