/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.service.sysservice.fileresolver;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.tinygroup.beancontainer.BeanContainer;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.fileresolver.FileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.service.ServiceProviderInterface;
import org.tinygroup.service.config.ServiceComponent;
import org.tinygroup.service.config.ServiceComponents;
import org.tinygroup.service.config.XmlConfigServiceLoader;
import org.tinygroup.service.exception.ServiceLoadException;
import org.tinygroup.service.registry.ServiceRegistry;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class XmlSysServiceFileProcessor
extends XmlConfigServiceLoader
implements FileProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlSysServiceFileProcessor.class);
    private static final String SERVICE_EXT_FILENAME = ".sysservice.xml";
    private ServiceProviderInterface provider;
    private ServiceRegistry reg;
    private List<ServiceComponents> list = new ArrayList<ServiceComponents>();

    public ServiceProviderInterface getProvider() {
        return this.provider;
    }

    public void setProvider(ServiceProviderInterface provider) {
        this.provider = provider;
    }

    public ServiceRegistry getReg() {
        return this.reg;
    }

    public void setReg(ServiceRegistry reg) {
        this.reg = reg;
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(SERVICE_EXT_FILENAME);
    }

    @Override
    public void process() {
        this.provider.setServiceRegistory(this.reg);
        XStream stream = XStreamFactory.getXStream((String)"service");
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664SysService\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            ServiceComponents components = (ServiceComponents)this.caches.get(fileObject.getAbsolutePath());
            if (components != null) {
                this.list.remove(components);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664SysService\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u8bfb\u53d6SysService\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            try {
                ServiceComponents oldComponents = (ServiceComponents)this.caches.get(fileObject.getAbsolutePath());
                if (oldComponents != null) {
                    this.list.remove(oldComponents);
                }
                InputStream inputStream = fileObject.getInputStream();
                ServiceComponents components = (ServiceComponents)stream.fromXML(inputStream);
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    LOGGER.errorMessage("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u51fa\u9519,\u6587\u4ef6\u8def\u5f84:{}", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
                }
                this.list.add(components);
                this.caches.put(fileObject.getAbsolutePath(), components);
            }
            catch (Exception e) {
                LOGGER.errorMessage("\u8bfb\u53d6SysService\u6587\u4ef6[{0}]\u51fa\u73b0\u5f02\u5e38", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
            }
            LOGGER.logMessage(LogLevel.INFO, "\u8bfb\u53d6SysService\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        try {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u6ce8\u518cSysService");
            this.loadService(this.provider.getServiceRegistory(), this.getFileResolver().getClassLoader());
            LOGGER.logMessage(LogLevel.INFO, "\u6ce8\u518cSysService\u7ed3\u675f");
        }
        catch (ServiceLoadException e) {
            LOGGER.errorMessage("\u6ce8\u518cSysService\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e, new Object[0]);
        }
        this.list.clear();
    }

    @Override
    public void setConfigPath(String path) {
    }

    @Override
    protected List<ServiceComponents> getServiceComponents() {
        return this.list;
    }

    @Override
    protected Object getServiceInstance(ServiceComponent component) throws Exception {
        BeanContainer container = BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader());
        try {
            if (component.getBean() == null || "".equals(component.getBean().trim())) {
                Class<?> clazz = Class.forName(component.getType());
                return container.getBean(clazz);
            }
            return container.getBean(component.getBean());
        }
        catch (Exception e) {
            LOGGER.logMessage(LogLevel.WARN, "\u67e5\u627eBean {}\u65f6\u53d1\u751f\u5f02\u5e38", new Object[]{component.getBean()});
            Class<?> clazz = Class.forName(component.getType());
            if (!clazz.isInterface()) {
                return clazz.newInstance();
            }
            throw e;
        }
    }
}

