/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.awt.Font;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.zkoss.image.AImage;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zul.Chart;
import org.zkoss.zul.Image;
import org.zkoss.zul.impl.CaptchaEngine;

public class Captcha
extends Image {
    private boolean _smartDrawCaptcha;
    private EventListener<Event> _smartDrawCaptchaListener;
    private static Random _random = new Random();
    private static final String EXCLUDE = "0123456789IOilo";
    private static final int CHAR_START = 48;
    private static final int CHAR_END = 122;
    private static final int CHAR_COUNT = 75;
    private static final Font[] DEFAULT_FONTS = new Font[]{new Font("Arial", 1, 30), new Font("Courier", 1, 30)};
    private int _intWidth = 200;
    private int _intHeight = 50;
    private String _fontColor = "#508093";
    private int _fontRGB = 5275795;
    private String _bgColor = "#FFFFFF";
    private int _bgRGB = 0xFFFFFF;
    private List<Font> _fonts = new ArrayList<Font>(9);
    private int _len = 5;
    private String _exclude = null;
    private String _value = "";
    private boolean _noise;
    private boolean _frame;
    private CaptchaEngine _engine;

    public Captcha() {
        this.setWidth("200px");
        this.setHeight("50px");
        this.randomValue();
        this.smartDrawCaptcha();
    }

    public List<Font> getFonts() {
        return this._fonts;
    }

    public Font[] getDefaultFonts() {
        return DEFAULT_FONTS;
    }

    public Font getFont(int j) {
        if (this._fonts.isEmpty()) {
            return DEFAULT_FONTS[j];
        }
        return this._fonts.get(j);
    }

    public void addFont(Font font) {
        this._fonts.add(font);
    }

    public void setFontColor(String color) {
        if (Objects.equals((Object)color, (Object)this._fontColor)) {
            return;
        }
        this._fontColor = color;
        this._fontRGB = this._fontColor == null ? 0 : Captcha.decode(this._fontColor);
        this.smartDrawCaptcha();
    }

    public String getFontColor() {
        return this._fontColor;
    }

    public int getFontRGB() {
        return this._fontRGB;
    }

    public void setBgColor(String color) {
        if (Objects.equals((Object)color, (Object)this._bgColor)) {
            return;
        }
        this._bgColor = color;
        this._bgRGB = this._bgColor == null ? 0 : Captcha.decode(this._bgColor);
        this.smartDrawCaptcha();
    }

    public String getBgColor() {
        return this._bgColor;
    }

    public int getBgRGB() {
        return this._bgRGB;
    }

    public void setWidth(String w) {
        if (Objects.equals((Object)w, (Object)this.getWidth())) {
            return;
        }
        this._intWidth = Chart.stringToInt(w);
        super.setWidth0(w);
        this.smartDrawCaptcha();
    }

    public void setHflex(String flex) {
        super.setHflex0(flex);
    }

    public int getIntWidth() {
        return this._intWidth;
    }

    public void setHeight(String h) {
        if (Objects.equals((Object)h, (Object)this.getHeight())) {
            return;
        }
        this._intHeight = Chart.stringToInt(h);
        super.setHeight0(h);
        this.smartDrawCaptcha();
    }

    public void setVflex(String flex) {
        super.setVflex0(flex);
    }

    public int getIntHeight() {
        return this._intHeight;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String text) throws WrongValueException {
        if (Strings.isBlank((String)text)) {
            throw new WrongValueException("empty not allowed");
        }
        if (!Objects.equals((Object)text, (Object)this._value)) {
            this._value = text;
            this.smartDrawCaptcha();
        }
    }

    public void setLength(int len) {
        if (len == this._len) {
            return;
        }
        this._len = len;
        this.randomValue();
        this.smartDrawCaptcha();
    }

    public int getLength() {
        return this._len;
    }

    public void setExclude(String exclude) {
        if (Objects.equals((Object)this._exclude, (Object)exclude)) {
            return;
        }
        this._exclude = exclude;
        this.randomValue();
        this.smartDrawCaptcha();
    }

    public String getExclude() {
        return this._exclude;
    }

    public void setNoise(boolean b) {
        this._noise = b;
    }

    public boolean isNoise() {
        return this._noise;
    }

    public void setFrame(boolean frame) {
        this._frame = frame;
    }

    public boolean isFrame() {
        return this._frame;
    }

    public String randomValue() {
        String exclude = this._exclude == null ? EXCLUDE : this._exclude;
        int len = this._len;
        StringBuffer sb = new StringBuffer(len);
        while (len > 0) {
            char c = (char)(48 + _random.nextInt(75));
            if (!Character.isLetterOrDigit(c) || exclude.indexOf(c) >= 0) continue;
            sb.append(c);
            --len;
        }
        this.setValue(sb.toString());
        return this.getValue();
    }

    public void setEngine(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setEngine((CaptchaEngine)Classes.newInstanceByThread((String)clsnm));
        }
    }

    public void setEngine(CaptchaEngine engine) {
        if (this._engine != engine) {
            this._engine = engine;
        }
        this.smartDrawCaptcha();
    }

    public CaptchaEngine getCaptchaEngine() throws UiException {
        if (this._engine == null) {
            this._engine = this.newCaptchaEngine();
        }
        return this._engine;
    }

    protected CaptchaEngine newCaptchaEngine() throws UiException {
        Object v;
        String PROP = "org.zkoss.zul.captcha.engine.class";
        String klass = Library.getProperty((String)"org.zkoss.zul.captcha.engine.class");
        if (klass == null) {
            throw new UiException("Library property,  org.zkoss.zul.captcha.engine.class, required");
        }
        try {
            v = Classes.newInstanceByThread((String)klass);
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap((Throwable)ex);
        }
        if (!(v instanceof CaptchaEngine)) {
            throw new UiException(CaptchaEngine.class + " must be implemented by " + v);
        }
        return (CaptchaEngine)v;
    }

    protected void smartDrawCaptcha() {
        if (this._smartDrawCaptcha) {
            return;
        }
        this._smartDrawCaptcha = true;
        if (this._smartDrawCaptchaListener == null) {
            this._smartDrawCaptchaListener = new SerializableEventListener<Event>(){

                public void onEvent(Event event) {
                    if (Strings.isBlank((String)Captcha.this.getWidth())) {
                        throw new UiException("captcha must specify width");
                    }
                    if (Strings.isBlank((String)Captcha.this.getHeight())) {
                        throw new UiException("captcha must specify height");
                    }
                    try {
                        byte[] bytes = Captcha.this.getCaptchaEngine().generateCaptcha((Object)Captcha.this);
                        AImage image = new AImage("captcha" + new Date().getTime(), bytes);
                        Captcha.this.setContent((org.zkoss.image.Image)image);
                    }
                    catch (IOException ex) {
                        throw UiException.Aide.wrap((Throwable)ex);
                    }
                    finally {
                        Captcha.this._smartDrawCaptcha = false;
                    }
                }
            };
            this.addEventListener("onSmartDrawCaptcha", this._smartDrawCaptchaListener);
        }
        Events.postEvent((String)"onSmartDrawCaptcha", (Component)this, null);
    }

    static int decode(String color) {
        if (color == null) {
            return 0;
        }
        if (color.length() != 7 || color.charAt(0) != '#') {
            throw new UiException("Incorrect color format (#RRGGBB) : " + color);
        }
        return Integer.parseInt(color.substring(1), 16);
    }
}

