/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.text.DateFormats;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.impl.Utils;
import org.zkoss.zk.ui.sys.BooleanPropertyAccess;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zul.Datebox;
import org.zkoss.zul.SimpleLocalTimeConstraint;
import org.zkoss.zul.impl.DateTimeFormatInputElement;
import org.zkoss.zul.mesg.MZul;

public class Timebox
extends DateTimeFormatInputElement {
    public static final String DEFAULT_FORMAT = "HH:mm";
    private boolean _btnVisible = true;
    private static Date _dummyDate = new Date();
    private static int DEFAULT_COLS_VALUE = Integer.MAX_VALUE;
    private static HashMap<String, PropertyAccess> _properties = new HashMap(1);

    public Timebox() {
        this._cols = DEFAULT_COLS_VALUE;
        this.setFormat("");
    }

    public Timebox(Date date) throws WrongValueException {
        this();
        this.setValue(date);
    }

    public Timebox(ZonedDateTime value) throws WrongValueException {
        this();
        this.setValueInZonedDateTime(value);
    }

    public Timebox(LocalDateTime value) throws WrongValueException {
        this();
        this.setValueInLocalDateTime(value);
    }

    public Timebox(LocalTime value) throws WrongValueException {
        this();
        this.setValueInLocalTime(value);
    }

    @Override
    public void setFormat(String format) throws WrongValueException {
        if (!Objects.equals((Object)this.getFormat(), (Object)format)) {
            String realformat = this.getRealFormat();
            if (realformat.indexOf("z") != -1) {
                String timezone = this.getFormattedTimezone();
                this.smartUpdate("timezone", timezone);
            }
            super.setFormat(format != null ? format : "");
        }
    }

    @Override
    public String getRealFormat() {
        String format = this.getFormat();
        if (format == null || format.length() == 0) {
            return this.getDefaultFormat();
        }
        int ts = Datebox.toStyle(format);
        return ts != -111 ? DateFormats.getTimeFormat((int)ts, (Locale)this._locale, (String)DEFAULT_FORMAT) : format;
    }

    @Override
    public void setValueInLocalDate(LocalDate value) throws WrongValueException {
        throw new UnsupportedOperationException("need time");
    }

    public boolean isButtonVisible() {
        return this._btnVisible;
    }

    public void setButtonVisible(boolean visible) {
        if (this._btnVisible != visible) {
            this._btnVisible = visible;
            this.smartUpdate("buttonVisible", visible);
        }
    }

    @Override
    public void setConstraint(String constr) {
        this.setConstraint(constr != null ? new SimpleLocalTimeConstraint(constr) : null);
    }

    protected String getDefaultFormat() {
        return DateFormats.getTimeFormat((int)2, (Locale)this._locale, (String)DEFAULT_FORMAT);
    }

    @Override
    protected Object coerceFromString(String value) throws WrongValueException {
        Date date;
        if (value == null || value.length() == 0) {
            return null;
        }
        String fmt = this.getRealFormat();
        DateFormat df = this.getDateFormat(fmt);
        try {
            date = df.parse(value);
        }
        catch (ParseException ex) {
            throw this.showCustomError(new WrongValueException((Component)this, MZul.DATE_REQUIRED, new Object[]{value, fmt}));
        }
        return date;
    }

    @Override
    protected String coerceToString(Object value) {
        DateFormat df = this.getDateFormat(this.getRealFormat());
        return value != null ? df.format((Date)value) : "";
    }

    protected DateFormat getDateFormat(String fmt) {
        SimpleDateFormat df = new SimpleDateFormat(fmt, this._locale != null ? this._locale : Locales.getCurrent());
        TimeZone tz = this._tzone != null ? this._tzone : TimeZones.getCurrent();
        df.setTimeZone(tz);
        return df;
    }

    private String getUnformater() {
        if (Utils.markClientInfoPerDesktop((Desktop)this.getDesktop(), (String)"org.zkoss.zul.Timebox.unformater.isSent")) {
            return Library.getProperty((String)"org.zkoss.zul.Timebox.unformater");
        }
        return null;
    }

    private Object[] getRealSymbols() {
        if (this._locale != null) {
            String localeName = this._locale.toString();
            if (Utils.markClientInfoPerDesktop((Desktop)this.getDesktop(), (String)(this.getClass().getName() + localeName))) {
                HashMap<String, String[]> map = new HashMap<String, String[]>(2);
                Calendar cal = Calendar.getInstance(this._locale);
                SimpleDateFormat df = new SimpleDateFormat("a", this._locale);
                cal.set(11, 3);
                String[] ampm = new String[2];
                ampm[0] = df.format(cal.getTime());
                cal.set(11, 15);
                ampm[1] = df.format(cal.getTime());
                map.put("APM", ampm);
                return new Object[]{localeName, map};
            }
            return new Object[]{localeName, null};
        }
        return null;
    }

    public String getZclass() {
        return this._zclass == null ? "z-timebox" : this._zclass;
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        String unformater;
        super.renderProperties(renderer);
        String realformat = this.getRealFormat();
        if (realformat.indexOf("z") != -1) {
            String timezone = this.getFormattedTimezone();
            renderer.render("timezoneAbbr", timezone);
        }
        if (this.getCols() == DEFAULT_COLS_VALUE) {
            Date value = (Date)this.getRawValue();
            int cols = 5;
            if (value != null) {
                cols = this.coerceToString(value).length();
            }
            this._cols = cols;
            renderer.render("cols", this.getCols());
        }
        if (!this._btnVisible) {
            renderer.render("buttonVisible", this._btnVisible);
        }
        if (!Strings.isBlank((String)(unformater = this.getUnformater()))) {
            renderer.render("unformater", unformater);
        }
        if (this._locale != null) {
            renderer.render("localizedSymbols", (Object)this.getRealSymbols());
        }
    }

    private String getFormattedTimezone() {
        return this.getDateFormat("z").format(_dummyDate);
    }

    @Override
    public PropertyAccess getPropertyAccess(String prop) {
        PropertyAccess pa = _properties.get(prop);
        if (pa != null) {
            return pa;
        }
        return super.getPropertyAccess(prop);
    }

    static {
        _properties.put("buttonVisible", (PropertyAccess)new BooleanPropertyAccess(){

            public void setValue(Component cmp, Boolean value) {
                ((Timebox)cmp).setButtonVisible(value);
            }

            public Boolean getValue(Component cmp) {
                return ((Timebox)cmp).isButtonVisible();
            }
        });
    }
}

