/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.jetbrains.annotations.NotNull;
import pl.project13.jgit.DescribeCommand;
import pl.project13.jgit.DescribeResult;
import pl.project13.jgit.JGitCommon;
import pl.project13.maven.git.GitCommitIdExecutionException;
import pl.project13.maven.git.GitDataProvider;
import pl.project13.maven.git.log.LoggerBridge;

public class JGitProvider
extends GitDataProvider {
    private File dotGitDirectory;
    private Repository git;
    private ObjectReader objectReader;
    private RevWalk revWalk;
    private RevCommit headCommit;
    private JGitCommon jGitCommon;

    @NotNull
    public static JGitProvider on(@NotNull File dotGitDirectory, @NotNull LoggerBridge log) {
        return new JGitProvider(dotGitDirectory, log);
    }

    JGitProvider(@NotNull File dotGitDirectory, @NotNull LoggerBridge log) {
        super(log);
        this.dotGitDirectory = dotGitDirectory;
        this.jGitCommon = new JGitCommon(log);
    }

    @Override
    public void init() throws GitCommitIdExecutionException {
        this.git = this.getGitRepository();
        this.objectReader = this.git.newObjectReader();
    }

    @Override
    public String getBuildAuthorName() throws GitCommitIdExecutionException {
        String userName = this.git.getConfig().getString("user", null, "name");
        return (String)MoreObjects.firstNonNull((Object)userName, (Object)"");
    }

    @Override
    public String getBuildAuthorEmail() throws GitCommitIdExecutionException {
        String userEmail = this.git.getConfig().getString("user", null, "email");
        return (String)MoreObjects.firstNonNull((Object)userEmail, (Object)"");
    }

    @Override
    public void prepareGitToExtractMoreDetailedRepoInformation() throws GitCommitIdExecutionException {
        try {
            Ref head = this.git.findRef("HEAD");
            if (head == null) {
                throw new GitCommitIdExecutionException("Could not get HEAD Ref, are you sure you have set the dotGitDirectory property of this plugin to a valid path?");
            }
            this.revWalk = new RevWalk(this.git);
            ObjectId headObjectId = head.getObjectId();
            if (headObjectId == null) {
                throw new GitCommitIdExecutionException("Could not get HEAD Ref, are you sure you have some commits in the dotGitDirectory?");
            }
            this.headCommit = this.revWalk.parseCommit((AnyObjectId)headObjectId);
            this.revWalk.markStart(this.headCommit);
        }
        catch (Exception e) {
            throw new GitCommitIdExecutionException("Error", e);
        }
    }

    @Override
    public String getBranchName() throws GitCommitIdExecutionException {
        try {
            return this.git.getBranch();
        }
        catch (IOException e) {
            throw new GitCommitIdExecutionException(e);
        }
    }

    @Override
    public String getGitDescribe() throws GitCommitIdExecutionException {
        return this.getGitDescribe(this.git);
    }

    @Override
    public String getCommitId() throws GitCommitIdExecutionException {
        return this.headCommit.getName();
    }

    @Override
    public String getAbbrevCommitId() throws GitCommitIdExecutionException {
        return this.getAbbrevCommitId(this.objectReader, this.headCommit, this.abbrevLength);
    }

    @Override
    public boolean isDirty() throws GitCommitIdExecutionException {
        try {
            return JGitCommon.isRepositoryInDirtyState(this.git);
        }
        catch (GitAPIException e) {
            throw new GitCommitIdExecutionException("Failed to get git status: " + e.getMessage(), e);
        }
    }

    @Override
    public String getCommitAuthorName() throws GitCommitIdExecutionException {
        return this.headCommit.getAuthorIdent().getName();
    }

    @Override
    public String getCommitAuthorEmail() throws GitCommitIdExecutionException {
        return this.headCommit.getAuthorIdent().getEmailAddress();
    }

    @Override
    public String getCommitMessageFull() throws GitCommitIdExecutionException {
        return this.headCommit.getFullMessage().trim();
    }

    @Override
    public String getCommitMessageShort() throws GitCommitIdExecutionException {
        return this.headCommit.getShortMessage().trim();
    }

    @Override
    public String getCommitTime() throws GitCommitIdExecutionException {
        long timeSinceEpoch = this.headCommit.getCommitTime();
        Date commitDate = new Date(timeSinceEpoch * 1000L);
        SimpleDateFormat smf = this.getSimpleDateFormatWithTimeZone();
        return smf.format(commitDate);
    }

    @Override
    public String getRemoteOriginUrl() throws GitCommitIdExecutionException {
        String url = this.git.getConfig().getString("remote", "origin", "url");
        return JGitProvider.stripCredentialsFromOriginUrl(url);
    }

    @Override
    public String getTags() throws GitCommitIdExecutionException {
        try {
            Repository repo = this.getGitRepository();
            ObjectId headId = this.headCommit.toObjectId();
            Collection<String> tags = this.jGitCommon.getTags(repo, headId);
            return Joiner.on((String)",").join(tags);
        }
        catch (GitAPIException e) {
            this.log.error("Unable to extract tags from commit: {} ({})", (Object)this.headCommit.getName(), (Object)((Object)((Object)e)).getClass().getName());
            return "";
        }
    }

    @Override
    public String getClosestTagName() throws GitCommitIdExecutionException {
        Repository repo = this.getGitRepository();
        try {
            return this.jGitCommon.getClosestTagName(repo);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    @Override
    public String getClosestTagCommitCount() throws GitCommitIdExecutionException {
        Repository repo = this.getGitRepository();
        try {
            return this.jGitCommon.getClosestTagCommitCount(repo, this.headCommit);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    @Override
    public void finalCleanUp() {
        if (this.revWalk != null) {
            this.revWalk.dispose();
        }
        if (this.git != null) {
            this.git.close();
            WindowCacheConfig config = new WindowCacheConfig();
            config.install();
        }
    }

    @VisibleForTesting
    String getGitDescribe(@NotNull Repository repository) throws GitCommitIdExecutionException {
        try {
            DescribeResult describeResult = DescribeCommand.on(repository, this.log).apply(this.gitDescribe).call();
            return describeResult.toString();
        }
        catch (GitAPIException ex) {
            ex.printStackTrace();
            throw new GitCommitIdExecutionException("Unable to obtain git.commit.id.describe information", ex);
        }
    }

    private String getAbbrevCommitId(ObjectReader objectReader, RevCommit headCommit, int abbrevLength) throws GitCommitIdExecutionException {
        try {
            AbbreviatedObjectId abbreviatedObjectId = objectReader.abbreviate((AnyObjectId)headCommit, abbrevLength);
            return abbreviatedObjectId.name();
        }
        catch (IOException e) {
            throw new GitCommitIdExecutionException("Unable to abbreviate commit id! You may want to investigate the <abbrevLength/> element in your configuration.", e);
        }
    }

    @NotNull
    private Repository getGitRepository() throws GitCommitIdExecutionException {
        Repository repository;
        FileRepositoryBuilder repositoryBuilder = new FileRepositoryBuilder();
        try {
            repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)repositoryBuilder.setGitDir(this.dotGitDirectory)).readEnvironment()).findGitDir()).build();
        }
        catch (IOException e) {
            throw new GitCommitIdExecutionException("Could not initialize repository...", e);
        }
        if (repository == null) {
            throw new GitCommitIdExecutionException("Could not create git repository. Are you sure '" + this.dotGitDirectory + "' is the valid Git root for your project?");
        }
        return repository;
    }

    @VisibleForTesting
    public void setRepository(Repository git) {
        this.git = git;
    }
}

