/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactResponse;
import software.amazon.awssdk.services.codeartifact.model.PackageDependency;
import software.amazon.awssdk.services.codeartifact.model.PackageDependencyListCopier;
import software.amazon.awssdk.services.codeartifact.model.PackageFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPackageVersionDependenciesResponse
extends CodeartifactResponse
implements ToCopyableBuilder<Builder, ListPackageVersionDependenciesResponse> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(ListPackageVersionDependenciesResponse.getter(ListPackageVersionDependenciesResponse::formatAsString)).setter(ListPackageVersionDependenciesResponse.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(ListPackageVersionDependenciesResponse.getter(ListPackageVersionDependenciesResponse::namespace)).setter(ListPackageVersionDependenciesResponse.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<String> PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("package").getter(ListPackageVersionDependenciesResponse.getter(ListPackageVersionDependenciesResponse::packageValue)).setter(ListPackageVersionDependenciesResponse.setter(Builder::packageValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("package").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(ListPackageVersionDependenciesResponse.getter(ListPackageVersionDependenciesResponse::version)).setter(ListPackageVersionDependenciesResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> VERSION_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionRevision").getter(ListPackageVersionDependenciesResponse.getter(ListPackageVersionDependenciesResponse::versionRevision)).setter(ListPackageVersionDependenciesResponse.setter(Builder::versionRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionRevision").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPackageVersionDependenciesResponse.getter(ListPackageVersionDependenciesResponse::nextToken)).setter(ListPackageVersionDependenciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<PackageDependency>> DEPENDENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dependencies").getter(ListPackageVersionDependenciesResponse.getter(ListPackageVersionDependenciesResponse::dependencies)).setter(ListPackageVersionDependenciesResponse.setter(Builder::dependencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PackageDependency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, NAMESPACE_FIELD, PACKAGE_FIELD, VERSION_FIELD, VERSION_REVISION_FIELD, NEXT_TOKEN_FIELD, DEPENDENCIES_FIELD));
    private final String format;
    private final String namespace;
    private final String packageValue;
    private final String version;
    private final String versionRevision;
    private final String nextToken;
    private final List<PackageDependency> dependencies;

    private ListPackageVersionDependenciesResponse(BuilderImpl builder) {
        super(builder);
        this.format = builder.format;
        this.namespace = builder.namespace;
        this.packageValue = builder.packageValue;
        this.version = builder.version;
        this.versionRevision = builder.versionRevision;
        this.nextToken = builder.nextToken;
        this.dependencies = builder.dependencies;
    }

    public final PackageFormat format() {
        return PackageFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String packageValue() {
        return this.packageValue;
    }

    public final String version() {
        return this.version;
    }

    public final String versionRevision() {
        return this.versionRevision;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasDependencies() {
        return this.dependencies != null && !(this.dependencies instanceof SdkAutoConstructList);
    }

    public final List<PackageDependency> dependencies() {
        return this.dependencies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependencies() ? this.dependencies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPackageVersionDependenciesResponse)) {
            return false;
        }
        ListPackageVersionDependenciesResponse other = (ListPackageVersionDependenciesResponse)((Object)obj);
        return Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.packageValue(), other.packageValue()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.versionRevision(), other.versionRevision()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasDependencies() == other.hasDependencies() && Objects.equals(this.dependencies(), other.dependencies());
    }

    public final String toString() {
        return ToString.builder((String)"ListPackageVersionDependenciesResponse").add("Format", (Object)this.formatAsString()).add("Namespace", (Object)this.namespace()).add("Package", (Object)this.packageValue()).add("Version", (Object)this.version()).add("VersionRevision", (Object)this.versionRevision()).add("NextToken", (Object)this.nextToken()).add("Dependencies", this.hasDependencies() ? this.dependencies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "package": {
                return Optional.ofNullable(clazz.cast(this.packageValue()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "versionRevision": {
                return Optional.ofNullable(clazz.cast(this.versionRevision()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "dependencies": {
                return Optional.ofNullable(clazz.cast(this.dependencies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPackageVersionDependenciesResponse, T> g) {
        return obj -> g.apply((ListPackageVersionDependenciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactResponse.BuilderImpl
    implements Builder {
        private String format;
        private String namespace;
        private String packageValue;
        private String version;
        private String versionRevision;
        private String nextToken;
        private List<PackageDependency> dependencies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPackageVersionDependenciesResponse model) {
            super(model);
            this.format(model.format);
            this.namespace(model.namespace);
            this.packageValue(model.packageValue);
            this.version(model.version);
            this.versionRevision(model.versionRevision);
            this.nextToken(model.nextToken);
            this.dependencies(model.dependencies);
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getPackageValue() {
            return this.packageValue;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        @Override
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getVersionRevision() {
            return this.versionRevision;
        }

        public final void setVersionRevision(String versionRevision) {
            this.versionRevision = versionRevision;
        }

        @Override
        public final Builder versionRevision(String versionRevision) {
            this.versionRevision = versionRevision;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PackageDependency.Builder> getDependencies() {
            List<PackageDependency.Builder> result = PackageDependencyListCopier.copyToBuilder(this.dependencies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependencies(Collection<PackageDependency.BuilderImpl> dependencies) {
            this.dependencies = PackageDependencyListCopier.copyFromBuilder(dependencies);
        }

        @Override
        public final Builder dependencies(Collection<PackageDependency> dependencies) {
            this.dependencies = PackageDependencyListCopier.copy(dependencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(PackageDependency ... dependencies) {
            this.dependencies(Arrays.asList(dependencies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(Consumer<PackageDependency.Builder> ... dependencies) {
            this.dependencies(Stream.of(dependencies).map(c -> (PackageDependency)((PackageDependency.Builder)PackageDependency.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPackageVersionDependenciesResponse build() {
            return new ListPackageVersionDependenciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeartifactResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPackageVersionDependenciesResponse> {
        public Builder format(String var1);

        public Builder format(PackageFormat var1);

        public Builder namespace(String var1);

        public Builder packageValue(String var1);

        public Builder version(String var1);

        public Builder versionRevision(String var1);

        public Builder nextToken(String var1);

        public Builder dependencies(Collection<PackageDependency> var1);

        public Builder dependencies(PackageDependency ... var1);

        public Builder dependencies(Consumer<PackageDependency.Builder> ... var1);
    }
}

