/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import java.util.List;
import java.util.Objects;

public class CORSRule {
    List<String> allowedHeaders;
    List<String> allowedMethods;
    List<String> allowedOrigins;
    List<String> exposeHeaders;
    Integer maxAgeSeconds;

    CORSRule() {
        this.allowedHeaders = null;
        this.allowedMethods = null;
        this.allowedOrigins = null;
        this.exposeHeaders = null;
        this.maxAgeSeconds = null;
    }

    protected CORSRule(BuilderImpl builder) {
        this.allowedHeaders = builder.allowedHeaders;
        this.allowedMethods = builder.allowedMethods;
        this.allowedOrigins = builder.allowedOrigins;
        this.exposeHeaders = builder.exposeHeaders;
        this.maxAgeSeconds = builder.maxAgeSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(CORSRule.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof CORSRule;
    }

    public List<String> allowedHeaders() {
        return this.allowedHeaders;
    }

    public List<String> allowedMethods() {
        return this.allowedMethods;
    }

    public List<String> allowedOrigins() {
        return this.allowedOrigins;
    }

    public List<String> exposeHeaders() {
        return this.exposeHeaders;
    }

    public Integer maxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    protected static class BuilderImpl
    implements Builder {
        List<String> allowedHeaders;
        List<String> allowedMethods;
        List<String> allowedOrigins;
        List<String> exposeHeaders;
        Integer maxAgeSeconds;

        protected BuilderImpl() {
        }

        private BuilderImpl(CORSRule model) {
            this.allowedHeaders(model.allowedHeaders);
            this.allowedMethods(model.allowedMethods);
            this.allowedOrigins(model.allowedOrigins);
            this.exposeHeaders(model.exposeHeaders);
            this.maxAgeSeconds(model.maxAgeSeconds);
        }

        @Override
        public CORSRule build() {
            return new CORSRule(this);
        }

        @Override
        public final Builder allowedHeaders(List<String> allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
            return this;
        }

        @Override
        public final Builder allowedMethods(List<String> allowedMethods) {
            this.allowedMethods = allowedMethods;
            return this;
        }

        @Override
        public final Builder allowedOrigins(List<String> allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
            return this;
        }

        @Override
        public final Builder exposeHeaders(List<String> exposeHeaders) {
            this.exposeHeaders = exposeHeaders;
            return this;
        }

        @Override
        public final Builder maxAgeSeconds(Integer maxAgeSeconds) {
            this.maxAgeSeconds = maxAgeSeconds;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public List<String> allowedHeaders() {
            return this.allowedHeaders;
        }

        public List<String> allowedMethods() {
            return this.allowedMethods;
        }

        public List<String> allowedOrigins() {
            return this.allowedOrigins;
        }

        public List<String> exposeHeaders() {
            return this.exposeHeaders;
        }

        public Integer maxAgeSeconds() {
            return this.maxAgeSeconds;
        }
    }

    public static interface Builder {
        public Builder allowedHeaders(List<String> var1);

        public Builder allowedMethods(List<String> var1);

        public Builder allowedOrigins(List<String> var1);

        public Builder exposeHeaders(List<String> var1);

        public Builder maxAgeSeconds(Integer var1);

        public CORSRule build();
    }
}

