/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.AnalyticsConfiguration;
import java.util.Objects;
import software.amazon.awssdk.crt.http.HttpHeader;

public class PutBucketAnalyticsConfigurationRequest {
    String bucket;
    String id;
    AnalyticsConfiguration analyticsConfiguration;
    String expectedBucketOwner;
    HttpHeader[] customHeaders;
    String customQueryParameters;

    PutBucketAnalyticsConfigurationRequest() {
        this.bucket = "";
        this.id = "";
        this.analyticsConfiguration = null;
        this.expectedBucketOwner = "";
        this.customHeaders = null;
        this.customQueryParameters = "";
    }

    protected PutBucketAnalyticsConfigurationRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.id = builder.id;
        this.analyticsConfiguration = builder.analyticsConfiguration;
        this.expectedBucketOwner = builder.expectedBucketOwner;
        this.customHeaders = builder.customHeaders;
        this.customQueryParameters = builder.customQueryParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(PutBucketAnalyticsConfigurationRequest.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof PutBucketAnalyticsConfigurationRequest;
    }

    public String bucket() {
        return this.bucket;
    }

    public String id() {
        return this.id;
    }

    public AnalyticsConfiguration analyticsConfiguration() {
        return this.analyticsConfiguration;
    }

    public String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    public HttpHeader[] customHeaders() {
        return this.customHeaders;
    }

    public String customQueryParameters() {
        return this.customQueryParameters;
    }

    protected static class BuilderImpl
    implements Builder {
        String bucket;
        String id;
        AnalyticsConfiguration analyticsConfiguration;
        String expectedBucketOwner;
        HttpHeader[] customHeaders;
        String customQueryParameters;

        protected BuilderImpl() {
        }

        private BuilderImpl(PutBucketAnalyticsConfigurationRequest model) {
            this.bucket(model.bucket);
            this.id(model.id);
            this.analyticsConfiguration(model.analyticsConfiguration);
            this.expectedBucketOwner(model.expectedBucketOwner);
            this.customHeaders(model.customHeaders);
            this.customQueryParameters(model.customQueryParameters);
        }

        @Override
        public PutBucketAnalyticsConfigurationRequest build() {
            return new PutBucketAnalyticsConfigurationRequest(this);
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public final Builder analyticsConfiguration(AnalyticsConfiguration analyticsConfiguration) {
            this.analyticsConfiguration = analyticsConfiguration;
            return this;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        @Override
        public final Builder customHeaders(HttpHeader[] customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        @Override
        public final Builder customQueryParameters(String customQueryParameters) {
            this.customQueryParameters = customQueryParameters;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String bucket() {
            return this.bucket;
        }

        public String id() {
            return this.id;
        }

        public AnalyticsConfiguration analyticsConfiguration() {
            return this.analyticsConfiguration;
        }

        public String expectedBucketOwner() {
            return this.expectedBucketOwner;
        }

        public HttpHeader[] customHeaders() {
            return this.customHeaders;
        }

        public String customQueryParameters() {
            return this.customQueryParameters;
        }
    }

    public static interface Builder {
        public Builder bucket(String var1);

        public Builder id(String var1);

        public Builder analyticsConfiguration(AnalyticsConfiguration var1);

        public Builder expectedBucketOwner(String var1);

        public Builder customHeaders(HttpHeader[] var1);

        public Builder customQueryParameters(String var1);

        public PutBucketAnalyticsConfigurationRequest build();
    }
}

