/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SaaSConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SaaSConfiguration> {
    private static final SdkField<String> ORGANIZATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationName").getter(SaaSConfiguration.getter(SaaSConfiguration::organizationName)).setter(SaaSConfiguration.setter(Builder::organizationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationName").build()}).build();
    private static final SdkField<String> HOST_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostUrl").getter(SaaSConfiguration.getter(SaaSConfiguration::hostUrl)).setter(SaaSConfiguration.setter(Builder::hostUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_NAME_FIELD, HOST_URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String organizationName;
    private final String hostUrl;

    private SaaSConfiguration(BuilderImpl builder) {
        this.organizationName = builder.organizationName;
        this.hostUrl = builder.hostUrl;
    }

    public final String organizationName() {
        return this.organizationName;
    }

    public final String hostUrl() {
        return this.hostUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SaaSConfiguration)) {
            return false;
        }
        SaaSConfiguration other = (SaaSConfiguration)obj;
        return Objects.equals(this.organizationName(), other.organizationName()) && Objects.equals(this.hostUrl(), other.hostUrl());
    }

    public final String toString() {
        return ToString.builder((String)"SaaSConfiguration").add("OrganizationName", (Object)this.organizationName()).add("HostUrl", (Object)this.hostUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationName": {
                return Optional.ofNullable(clazz.cast(this.organizationName()));
            }
            case "HostUrl": {
                return Optional.ofNullable(clazz.cast(this.hostUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SaaSConfiguration, T> g) {
        return obj -> g.apply((SaaSConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String organizationName;
        private String hostUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(SaaSConfiguration model) {
            this.organizationName(model.organizationName);
            this.hostUrl(model.hostUrl);
        }

        public final String getOrganizationName() {
            return this.organizationName;
        }

        public final void setOrganizationName(String organizationName) {
            this.organizationName = organizationName;
        }

        @Override
        public final Builder organizationName(String organizationName) {
            this.organizationName = organizationName;
            return this;
        }

        public final String getHostUrl() {
            return this.hostUrl;
        }

        public final void setHostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
        }

        @Override
        public final Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public SaaSConfiguration build() {
            return new SaaSConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SaaSConfiguration> {
        public Builder organizationName(String var1);

        public Builder hostUrl(String var1);
    }
}

