/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VehicleWeightUnit {
    KILOGRAMS("Kilograms"),
    POUNDS("Pounds"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VehicleWeightUnit> VALUE_MAP;
    private final String value;

    private VehicleWeightUnit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VehicleWeightUnit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VehicleWeightUnit> knownValues() {
        EnumSet<VehicleWeightUnit> knownValues = EnumSet.allOf(VehicleWeightUnit.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VehicleWeightUnit.class, VehicleWeightUnit::toString);
    }
}

