/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentClient;
import software.amazon.awssdk.services.lookoutequipment.internal.UserAgentUtils;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsResponse;

public class ListInferenceExecutionsIterable
implements SdkIterable<ListInferenceExecutionsResponse> {
    private final LookoutEquipmentClient client;
    private final ListInferenceExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInferenceExecutionsIterable(LookoutEquipmentClient client, ListInferenceExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInferenceExecutionsResponseFetcher();
    }

    public Iterator<ListInferenceExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListInferenceExecutionsResponseFetcher
    implements SyncPageFetcher<ListInferenceExecutionsResponse> {
        private ListInferenceExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListInferenceExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInferenceExecutionsResponse nextPage(ListInferenceExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListInferenceExecutionsIterable.this.client.listInferenceExecutions(ListInferenceExecutionsIterable.this.firstRequest);
            }
            return ListInferenceExecutionsIterable.this.client.listInferenceExecutions((ListInferenceExecutionsRequest)((Object)ListInferenceExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

