package com.bxm.abtest.facade.enums;

import lombok.Getter;

/**
 * @author zhangdong
 * @date 2023/8/30
 */
@Getter
public enum RequestTypeEnum {
    /**
     * 发券
     */
    TICKET(1, "发券", "bxmid"),

    ACTIVITY(2, "活动", "spm"),

    ;


    private final Integer type;

    private final String desc;

    private final String logName;

    RequestTypeEnum(Integer type, String desc, String logName) {
        this.type = type;
        this.desc = desc;
        this.logName = logName;
    }

    public static String getLogNameByType(Integer type) {
        for (RequestTypeEnum temp : RequestTypeEnum.values()) {
            if (temp.type.equals(type)) {
                return temp.logName;
            }
        }
        return null;
    }
}
