package com.bxm.abtest.facade.module;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @author zhangdong
 * @date 2023/8/18
 */
@Data
@Accessors(chain = true)
public class AbtestShuntRequest {

    /**
     * 用户id
     */
    @NotEmpty(message = "用户id不能为空")
    private String userId;

    /**
     * 广告位
     */
    @NotEmpty(message = "广告位不能为空")
    private String positionId;

    /**
     * 实验场景
     */
    @NotEmpty(message = "实验场景code不能为空")
    private String experimentSceneCode;

    private String uniqueId;

    /**
     * 请求类型 1发券 2活动
     */
    @NotNull(message = "请求类型不能为空")
    private Integer requestType;
}
