package com.bxm.abtest.facade.service;

import com.bxm.abtest.facade.constant.FacadeConstants;
import com.bxm.abtest.facade.module.AbtestShuntRequest;
import com.bxm.abtest.facade.module.AbtestShuntResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * @author zhangdong
 * @date 2023/8/18
 */
@FeignClient(name = FacadeConstants.SHUNT_SERVER_NAME)
public interface AbtestShuntFacadeService {

    /**
     * 获取实验下的版本code
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/facade/abtest/shunt/getShuntVersion")
    AbtestShuntResponse getShuntVersion(@RequestBody @Valid AbtestShuntRequest request);
}
