package com.bxm.activites;

public interface PopupService {
	
	/**
	 * 依据CTR值
	 * 根据广告位获取广告位下面的 首页弹窗、挽留弹窗
	 * @param position
	 * @param type 弹窗类型
	 * @return 首页弹窗、挽留弹窗
	 */
	PopupVo getPopupByPosition(String position,Integer type);

	/**
	 * 获取活动配置的弹窗，
	 * 根据广告位下各弹窗CTR值获取弹窗信息
	 * @param position 广告位
	 * @param activityId 活动ID
	 * @param type 类型
	 * @return 出券弹窗或者null
	 */
	PopupVo getTicketPopupByPostionAndActivityId(String position,Long activityId,Integer type);


	/**
	 * 依据参与率获取广告位下面的挽留弹窗
	 * @param position 广告位
	 * @param usedPopupIds 已经出过的弹窗
	 * @return 首页弹窗、挽留弹窗
	 */
	PopupVo getStayPopupByPosition(String position,String usedPopupIds);

}
