package com.bxm.activites.facade.model;

import org.apache.commons.collections.CollectionUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/**
 * 弹窗参与率实体
 * @author bcc
 */
public class PopupJoinRateInfo implements Serializable,Comparable<PopupJoinRateInfo> {

    /**
     * 弹窗ID
     */
    private String popupId;

    /**
     * 首页UV
     */
    private long indexUv;

    /**
     * 参数UV
     */
    private long joinUv;

    /**
     * 参与率
     */
    private double joinRate;

    /**
     * 参与率类型，历史,2小时，24小时，默认
     * {@link com.bxm.activites.facade.constant.JoinRateEnum.code}
     */
    private String type;

    public String getPopupId() {
        return popupId;
    }

    public void setPopupId(String popupId) {
        this.popupId = popupId;
    }

    public long getIndexUv() {
        return indexUv;
    }

    public void setIndexUv(long indexUv) {
        this.indexUv = indexUv;
    }

    public long getJoinUv() {
        return joinUv;
    }

    public void setJoinUv(long joinUv) {
        this.joinUv = joinUv;
    }

    public double getJoinRate() {
        return joinRate;
    }

    public void setJoinRate(double joinRate) {
        this.joinRate = joinRate;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public int compareTo(PopupJoinRateInfo o) {
        return Double.compare(o.getJoinRate(),joinRate);
    }

    @Override
    public String toString() {
        return "PopupJoinRateInfo{" +
                "popupId='" + popupId + '\'' +
                ", indexUv=" + indexUv +
                ", joinUv=" + joinUv +
                ", joinRate=" + joinRate +
                ", type='" + type + '\'' +
                '}';
    }
}
