package com.bxm.activites.facade.service;


import com.bxm.activites.facade.model.ActivityAwardRelationDto;
import com.bxm.activites.facade.model.ActivityDto;
import com.bxm.activites.facade.model.ActivityPositionRelationDto;
import com.bxm.activites.facade.model.ActivityStyleDto;


import java.util.List;
import java.util.Map;

/**
 * Created by wuwenquan on 2018/7/3.
 */
public interface ActivityBackService {

    /**
     * @user wuwenquan
     * @Description 保存或更新活动基本信息
     * @date 2018/7/16
     * @param
     * @return
     */
    ActivityDto saveBaseActivity(ActivityDto activityDto);
    /**
     * @user wuwenquan
     * @Description 根据活动ID删除活动样式
     * @date 2018/7/16
     * @param
     * @return
     */
    void deleteActivityStyle(Long activityId);
    /**
     * @user wuwenquan
     * @Description 保存活动样式
     * @date 2018/7/16
     * @param
     * @return
     */
    void saveActivityStyle(ActivityStyleDto activityStyleDto);
    /**
     * @user wuwenquan
     * @Description 批量保存活动，奖品关联关系
     * @date 2018/7/16
     * @param
     * @return
     */
    void saveActivityAwardRelationList(List<ActivityAwardRelationDto> activityAwardRelationList,Long activityId);
    /**
     * @user wuwenquan
     * @Description 批量保存活动，广告位关联关系
     * @date 2018/7/16
     * @param
     * @return
     */
    void saveActivityPositionRelationList(List<ActivityPositionRelationDto> activityPositionRelationDtoList,Long activityId);

    /**
     * @user wuwenquan
     * @Description 更新活动状态
     * @date 2018/7/16
     * @param
     * @return
     */
    void updateActivityStatus(ActivityDto activityDto);


    /**
     * @user wuwenquan
     * @Description 查询单个活动基本信息
     * @date 2018/7/16
     * @param
     * @return
     */
    ActivityDto findActivityById(Long id) throws Exception;
    /**
     * @user wuwenquan
     * @Description 查询某个活动对应的活动，奖品关联表信息
     * @date 2018/7/16
     * @param
     * @return
     */
    List<ActivityAwardRelationDto> findActivityAwardRelationListByActivityId(Long activityId);
    /**
     * @user wuwenquan
     * @Description 查询某个活动关联的广告位个数
     * @date 2018/7/16
     * @param
     * @return
     */
    Integer findActivityPositionCount(Long activityId);

    /**
     * @user wuwenquan
     * @Description 查询某个活动对应的活动广告位关联表列表
     * @date 2018/7/16
     * @param
     * @return
     */
    List<ActivityPositionRelationDto>  findActivityPositionListByActivityId(Long activityId);
    /**
     * @user wuwenquan
     * @Description 通过活动Id查找活动样式信息
     * @date 2018/7/16
     * @param
     * @return
     */
    ActivityStyleDto findActivityStyleByActivityId(Long activityId);
    /**
     * @user wuwenquan
     * @Description 查询符合查询条件的活动个数
     * @date 2018/7/16
     * @param params activityId 活动Id
     * @param params activityName 模糊查询活动名称
     * @param params activityType 活动类型
     * @param params activityPlanner 活动策划
     * @param params activityDesigner 活动设计
     * @param params isBack          是否备用
     * @param params showState       显示活动状态(0,1,2;未投放，启用，停用)
     * @return
     */
    Integer findTotalCount(Map params);
    /**
     * @user wuwenquan
     * @Description 查询符合查询条件的分页活动基本信息
     * @date 2018/7/16
     * @param params activityId 活动Id
     * @param params activityName 模糊查询活动名称
     * @param params activityType 活动类型
     * @param params activityPlanner 活动策划
     * @param params activityDesigner 活动设计
     * @param params isBack          是否备用
     * @param params showState       显示活动状态(0,1,2;未投放，启用，停用)
     * @param params offset limit  分页信息
     * @return
     */
    List<ActivityDto>   findActivityByPage(Map params) throws Exception;
    /**
     * @user wuwenquan
     * @Description 查询某个活动关联的奖品个数
     * @date 2018/7/16
     * @param
     * @return
     */
    Integer findActivityAwardRelationCount(Long activityId);
    /**
     * @user wuwenquan
     * @Description 查询某个活动关联的广告位Id集合
     * @date 2018/7/16
     * @param
     * @return
     */
    List<String> findActivityPositionIdList(Long activityId);
    /**
     * @user wuwenquan
     * @Description 根据活动Id删除活动广告位关联关系
     * @date 2018/7/23
     * @param
     * @return
     */
     void deleteActivityPositionRelationByActivityId(Long activityId);
    /**
     * @user wuwenquan
     * @Description 根据活动Id删除活动奖品关系关系
     * @date 2018/7/23
     * @param
     * @return
     */
     void deleteActivityAwardRelationByActivityId(Long activityId);
    /**
     * @user wuwenquan
     * @Description 根据广告位Id集合绑定长常规活动
     * @date 2018/7/23
     * @param
     * @return
     */
     void saveActivityPOsitionRelationList(List<String>  positionIds);
    /**
     * @user wuwenquan
     * @Description 根据广告位是否匹配常规活动 删除或增加关联关系
     * @date 2018/7/23
     * @param
     * @return
     */
    void saveActivityPOsitionRelationList(String  positionId,Boolean flag);
    /**
     * @user wuwenquan
     * @Description 更改活动与广告关联表是否失效字段
     * @date 2018/7/23
     * @param
     * @return
     */
    void  updateIsExpired(String positionId,List<Long> activityIds);

    void  savePopupPositionRelationList(List<String> positionIds);
}
