package com.bxm.activites.facade.service;

import com.bxm.activites.facade.model.ActivityMsgVo;
import com.bxm.activites.facade.model.ActivityRequest;
import com.bxm.activites.facade.model.PositionNewConfig;

import java.util.Set;

public interface ActivityBaseService {

    /**
     * @user xavier
     * @Description 校验传参
     * @date 2018/7/4
     * @param
     * @return
     */
    ActivityRequest checkRequest(ActivityRequest activityRequest);

    /**
     * @user xavier
     * @Description 获取活动基本信息
     * @date 2018/7/4
     * @return
     */
    ActivityMsgVo get(ActivityRequest activityRequest);

    /**
     * @user xavier
     * @Description 通过活动ID和UID获取用户该活动剩余参与次数
     * @date 2018/7/4
     * @return
     */
    int getTime(ActivityRequest activityRequest);

    /**
     * @user xavier
     * @Description 添加用户活动参与次数
     * @date 2018/7/4
     * @return
     */
    int join(ActivityRequest activityRequest);

    /**
     * 从redis中获取广告位配置信息
     * @param adPositionId
     * @date 2018/7/23
     * @return
     */
    Set<String> getConfig(String adPositionId);

    PositionNewConfig getNewConfig(String adPositionId);
}