package com.bxm.activites.facade.service;

import com.bxm.activites.facade.model.ActivityConfigDto;

/**
 * @author zhounan
 * created on 2018/7/25
 */
public interface ActivityConfigService {

    /**
     * 新增
     * @param activityConfigDto 对象
     * @return 0/1
     */
    int addProp(ActivityConfigDto activityConfigDto);

    /**
     * 根据key获取属性值
     * @param key 属性名
     * @return 属性值
     */
    String getByKey(String key);

    /**
     * 删除属性
     * @param key 属性名
     * @return 0/1
     */
    int deleteByKey(String key);

    /**
     * 修改属性值
     * @param propKey 属性名
     * @param propValue 属性值
     * @param desc 属性描述
     * @return 0/1
     */
    int saveOrUpdate(String propKey, String propValue, String desc);
}
