package com.bxm.activites.facade.service;

import com.bxm.activites.facade.model.ActivityRequestDto;
import com.bxm.activites.facade.model.InfoActivity;
import com.bxm.activites.facade.model.WeightEntry;

import java.util.List;
import java.util.Map;

/**
 * <h3>Activity Service</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/20
 */
public interface ActivityService {

    
    /**  
	 * @Title: getActMsg  
	 * @Description:  获取活动信息
	 * @author xavier  
	 * @throws Exception 
	 * @date 2018年5月9日
	 */  
    InfoActivity getActMsg(String actId);
	
	/**  
	 * @Title: getActMsg  
	 * @Description:  获取活动信息MAP
	 * @author xavier  
	 * @date 2018年5月9日
	 */  
	Map<Long, Double> getBizActMsg(String positionId);

	/**
	 * 获取人均点击
	 * @param positionId
	 * @param dafaultView
	 * @param defaultRepeatClicks
	 * @param  activityIdFactor 活动ID及人工系数
	 * @return
	 */
	List<WeightEntry>  getPerClick(String positionId, String dafaultView, String defaultRepeatClicks, Map<Integer, Integer> activityIdFactor);

	/***
	 * 获取活动在广告位下历史uv数据，筛选阈值以下活动列表
	 * @param activityIdFactor
	 * @param positionId
	 * @param dafaultView uv阈值
	 * @return
	 */
    List<WeightEntry> getActivityWeightUnderThreshold(Map<Integer, Integer> activityIdFactor, String positionId, int dafaultView);

    /**
	 *
	 * @param positionId
	 * @param  activityIdFactor 活动id对应人工系数Map
	 * @return
	 */
	List<WeightEntry>  getPerClick(String positionId, Map<Integer, Integer> activityIdFactor);

//	/**
//	 * @Title: getDefaultActMsg
//	 * @Description:  获取默认活动信息
//	 * @author xavier
//	 * @date 2018年5月9日
//	 */
//	InfoActivity getDefaultActMsg();

//	/**
//	 * @Title: getBakActMsg
//	 * @Description:  获取备用活动信息
//	 * @author xavier
//	 * @date 2018年5月9日
//	 */
//	Map<Integer, Integer> getBakActMsg();

	/**
	 * @Title: getActivity
	 * @Description:  根据用户和positionId 获取活动信息
	 * @author xavier
	 * @date 2018年5月15日
	 */
	InfoActivity getActivity(String uid, String positionId);

	/**
	 * 扣减活动奖品库存，扣减单位为1
	 * @param activityId
	 * @param awardId
	 * @return
	 */
	Boolean subAwardAmount(Long activityId, Long awardId);

	/**
	 * 增加活动奖品库存（回滚使用）
	 * @param activityId
	 * @param awardId
	 * @return
	 */
	Boolean addAwardAmount(Long activityId, Long awardId);

	/**
	 * 获取所有广告位对应的活动数量
	 * @return
	 */
	Map<String,Integer> getPositionActivityCount();

	/**
	 *
	 * @param positionId
	 * @param activityIdFactor 活动id对应人工系数Map
	 * @return
	 */
	List<WeightEntry> getPerClickNew(String positionId, Map<Integer,Integer> activityIdFactor);


	/**
	 * 获取历史人均券点击
	 * @param positionId
	 * @param activityId
	 * @return
	 */
	double getTotalPerClick(String positionId, Integer activityId);

	/**
	 * 获取活动在广告位下的历史uv
	 * @param positionId
	 * @param activityId
	 * @return
	 */
	long getTotalUv(String positionId, Integer activityId);

	/**
	 * 获取活动
	 * @param dto
	 * @return
	 */
	InfoActivity getActivity2(ActivityRequestDto dto);
}
