package com.bxm.activites.facade.service;

import com.bxm.activites.facade.model.ActivityRedirectDto;
import com.bxm.activites.facade.model.AdMaterialApiVo;

import java.util.HashMap;
import java.util.Map;

/**
 * 活动素材服务
 *
 * @author allen
 * @since 1.0.0
 */
public interface AdMaterialApiService {

    /**
     * 扩展服务，不清楚的请不要调用。
     *
     * 用于 华北2 等其他备用区域调用获取素材的服务。
     * @param adPositionId
     * @return
     */
    AdMaterialApiVo getAdMaterial(String adPositionId);

    /**
     * 扩展服务，不清楚的请不要调用。
     *
     * 用于 华北2 等其他备用区域调用统计的服务。
     * @param key
     * @return
     */
    long increment(String key);

    /**
     * 获取广告位素材
     * 2018-10-11逻辑修改：先判断广告位是否有直投素材和可用直投券,有的话返回直投素材
     * @param params parameters
     * @return material entity
     * @throws Exception
     */
    AdMaterialApiVo getAdMaterial(HashMap<String, String> params) throws Exception;

    /**
     * 获取跳转活动地址
     * @param params
     * @return
     * @throws Exception
     */
    String redirectAdUrl(HashMap<String, String> params) throws Exception;

    /**
     * 广告位素材曝光
     * @param adPositionId
     * @param mediaAdPositionId
     * @param adPositionMaterialId
     * @return
     */
    @Deprecated
    boolean exposure(String adPositionId, Long mediaAdPositionId, Long adPositionMaterialId);

    /**
     * 广告位素材点击
     * @param adPositionId
     * @param mediaAdPositionId
     * @param adPositionMaterialId
     * @return
     */
    @Deprecated
    boolean click(String adPositionId, Long mediaAdPositionId, Long adPositionMaterialId);

    /**
     * 广告位素材曝光
     * @param adPositionId
     * @param mediaAdPositionId
     * @param adPositionMaterialId
     * @return
     */
    boolean exposure(String adPositionId, Long mediaAdPositionId, Long adPositionMaterialId,String ipAddress);

    /**
     * 广告位素材点击
     * @param adPositionId
     * @param mediaAdPositionId
     * @param adPositionMaterialId
     * @return
     */
    boolean click(String adPositionId, Long mediaAdPositionId, Long adPositionMaterialId,String ipAddress);

    /**
     * 直投素材点击
     * @param adMaterialParams
     * @return
     */
    String redirectDirectTicketUrl(HashMap<String,String> adMaterialParams);

    /**
     * 获取h5链接直投券
     * @param paramMap
     */
    String getDirectTicketForH5(HashMap<String, String> paramMap);
}
