package com.bxm.activites.facade.service;



import com.bxm.activites.facade.model.ActivityDto;
import com.bxm.activites.facade.model.AwardDto;

import java.util.List;
import java.util.Map;

/**
 * Created by wuwenquan on 2018/7/8.
 */
public interface AwardService {
     /**
      * @user wuwenquan
      * @Description 保存或更新奖品
      * @date 2018/7/16
      * @param
      * @return
      */
     AwardDto saveOrUpdate(AwardDto awardDto);
     /**
      * @user wuwenquan
      * @Description 查询某个奖品信息
      * @date 2018/7/16
      * @param
      * @return
      */
     AwardDto findOne(Long id);
     /**
      * @user wuwenquan
      * @Description 查询奖品关联的活动个数
      * @date 2018/7/16
      * @param
      * @return
      */
     Integer getActivityCount(Long id);
     /**
      * @user wuwenquan
      * @Description 查询符合查询条件的奖品总个数
      * @date 2018/7/16
      * @param params awrdId 奖品ID
      * @param params awardName 奖品名称
      * @return
      */
     Integer findTotalCount(Map params);
     /**
      * @user wuwenquan
      * @Description 多条件分页查询奖品信息列表
      * @date 2018/7/16
      * @param params awrdId 奖品ID
      * @param params awardName 奖品名称
      * @param params offset  分页起始行
      * @param params limit  分页查询页数
      * @return
      */
     List<AwardDto> findPage(Map params);
     /**
      * @user wuwenquan
      * @Description 查询奖品关联的活动Id集合
      * @date 2018/7/16
      * @param
      * @return
      */
     List<Long> findActivityIds(Long id);

}
