package com.bxm.activites.facade.service;

import java.util.List;

/**
 * @author zhounan
 * created on 2018/7/23
 */
public interface PositionConfigBackService {

    /**
     * 是否匹配常规活动
     *
     * @param positionId 广告位id
     * @param matched    是否匹配常规活动
     * @return 0/1
     */
    int updateMathed(String positionId, Integer matched);

    /**
     * 匹配常规活动的广告位集合
     *
     * @return 广告位id集合
     */
    List<String> listByMatched();


    /**
     * 获取广告位是否匹配常规活动状态
     * @param positionId 广告位id
     * @return 匹配状态
     */
    Integer getMatchedByPositionId(String positionId);

}
