/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.activites.controller;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.activites.facade.model.ActivityMsgVo;
import com.bxm.activites.facade.model.ActivityRequest;
import com.bxm.activites.facade.service.ActivityBaseService;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/activity"})
public class ActivityController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivityController.class);
    @Reference(version="1.0.0")
    private ActivityBaseService activityBaseService;

    @RequestMapping(value={"/get"}, produces={"application/json"})
    ActivityMsgVo get(ActivityRequest activityRequest, HttpServletResponse response) {
        try {
            response.setHeader("Access-Control-Allow-Origin", "*");
            activityRequest = this.activityBaseService.checkRequest(activityRequest);
            return this.activityBaseService.get(activityRequest);
        }
        catch (Exception e) {
            LOGGER.error("ACTIVITY GET ERROR", (Throwable)e);
            return new ActivityMsgVo();
        }
    }

    @RequestMapping(value={"/gettime"}, produces={"application/json"})
    int getTime(ActivityRequest activityRequest, HttpServletResponse response) {
        try {
            response.setHeader("Access-Control-Allow-Origin", "*");
            activityRequest = this.activityBaseService.checkRequest(activityRequest);
            return this.activityBaseService.getTime(activityRequest);
        }
        catch (Exception e) {
            LOGGER.error("ACTIVITY GETTIME ERROR", (Throwable)e);
            return 8;
        }
    }

    @RequestMapping(value={"/join"}, produces={"application/json"})
    int join(ActivityRequest activityRequest, HttpServletResponse response) {
        try {
            response.setHeader("Access-Control-Allow-Origin", "*");
            activityRequest = this.activityBaseService.checkRequest(activityRequest);
            return this.activityBaseService.join(activityRequest);
        }
        catch (Exception e) {
            LOGGER.error("ACTIVITY JOIN ERROR", (Throwable)e);
            return 8;
        }
    }
}

