package com.bxm.acl.facade;

import com.bxm.acl.facade.model.ResultModel;
import com.bxm.acl.facade.model.UserVo;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author yirenjie
 * createDate:  2018/8/6
 */
public class AclAuthInterceptor implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AclAuthInterceptor.class);
    private final int SYSTEM_ID;   // 系统id
    public static final String USER_KEY = "user";
    protected static final String SESSION_USER_NAME = "user_name";

    @Resource
    private AclUserManagerService aclUserManagerService;

    public AclAuthInterceptor(int systemId) {
        this.SYSTEM_ID = systemId;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
        String token = Utils.getToken(request);
        LOGGER.debug("请求权限管理系统,token={},systemId={},uri={}", token, this.SYSTEM_ID, request.getRequestURI());
        if (token == null) {
            Utils.sendErrorMsg(response, "用户未登录", "10000002");
            return false;
        }
        try {
            ResultModel<UserVo> result = aclUserManagerService.auth(token, this.SYSTEM_ID, request.getRequestURI());
            if (!result.isSuccessed()){
                Utils.sendErrorMsg(response, result.getErrorDesc(), result.getErrorCode());
                LOGGER.warn("权限系统拒绝,msg={}", result.getErrorDesc());
                return false;
            }
            if (StringUtils.equals(HttpStatus.FORBIDDEN.value()+"", result.getErrorCode())) {
                Utils.sendErrorMsg(response, "权限不足,如需继续访问请联系管理员", "");
                LOGGER.warn("token={},systemId={},uri={}无权限", token, this.SYSTEM_ID, request.getRequestURI());
                return false;
            }
            UserVo userVo = result.getReturnValue();
            request.setAttribute(USER_KEY, userVo);
            request.setAttribute(SESSION_USER_NAME, userVo.getUsername());
            LOGGER.info("用户权限验证成功user:"+userVo.getUsername()+",ip:"+ Utils.getIp(request) +",访问内容:"+request.getRequestURI());
        }catch (Exception e){
            LOGGER.error("请求权限管理系统发生异常,token={},systemId={},uri={}:", token, this.SYSTEM_ID, request.getRequestURI(), e);
            Utils.sendErrorMsg(response, "权限系统异常,请稍候再试", "");
            return false;
        }
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {

    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object o, Exception e) throws Exception {

    }
}
