package com.bxm.acl.facade;

import com.bxm.acl.facade.model.ResultModel;
import com.bxm.acl.facade.model.UserDto;
import com.bxm.acl.facade.model.UserVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name = "adsacl")
public interface AclUserManagerService {

    /**
     * 注册接口
     * @param user
     */
    @RequestMapping(value = "/user/manage/reg", method = { RequestMethod.POST })
    void reg(UserDto user);

    /**
     * 修改密码
     * @param ro
     */
    @RequestMapping(value = "/user/manage/changePassword", method = { RequestMethod.POST })
    void changePassword(UserDto ro);

    /**
     * 同步用户信息接口
     * @param user
     */
    @RequestMapping(value = "/user/manage/syncUserInfo", method = { RequestMethod.POST })
    void syncUserInfo(UserDto user);

    /**
     * 认证并返回用户信息
     * @param token
     * @return
     */
    @RequestMapping(value = "/user/manage/auth", method = { RequestMethod.POST })
    ResultModel<UserVo> auth(@RequestParam("token") String token,
                             @RequestParam("systemId") Integer systemId,
                             @RequestParam("urlAddress") String urlAddress);

}
