package com.bxm.acl.facade.model;

import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * <h3>用户</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2017/12/29 14:02
 */
public class UserVo implements Serializable {


	private static final long serialVersionUID = 1257020995526059895L;
	//id
	private Integer id;

	//真实姓名
	private String realname;

	//密码
	private String password;

	//用户名唯一
	private String username;
	
	/** 用户角色列表 */  
	private List<String> roleCodes;

	private String ip;

	private String mobile;

	public List<String> getRoleCodes() {
		return roleCodes;
	}

	public void setRoleCodes(List<String> roleCodes) {
		this.roleCodes = roleCodes;
	}

	public String getRealname() {
		return realname;
	}

	public void setRealname(String realname) {
		this.realname = realname;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	/**
	 * @Title: checkUserOnlyOneRole  
	 * @Description:  判断用户是否只有一个角色
	 * @author xavier  
	 * @date 2018年4月12日
	 */  
	public String getUserNameOnlyEqualRole(String roleCode){
		if (roleCodes == null || roleCodes.size() != 1) {
			return null;
		}
		if (roleCodes.get(0).equals(roleCode)) {
			return StringUtils.isNotEmpty(username) ? username : null;
		}
		return null;
	}


	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}
}
