/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.acl.facade;

import com.bxm.acl.facade.model.AuthorRo;
import com.bxm.acl.facade.model.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
 * @ClassName AclAuthorService.java
 * @Description 功能描述：用户权限接口
 * @author leon 2018年4月13日 下午4:31:01
 * @CopyRight 杭州微财网络科技有限公司
 */
@FeignClient(name = "adsacl")
public interface AclAuthorService {

    /**
     * @Description 方法描述：根据用户id和系统id查询菜单
     * @author leon 2018年4月25日 下午7:54:53
     * @CopyRight 杭州微财网络科技有限公司
     * @param systemId
     * @param userId
     * @return
     */
    @RequestMapping(value = "/author/getMenuTreeList", method = RequestMethod.GET)
    ResultModel<List<AuthorRo>> getMenuTreeList(@RequestParam(value = "systemId", required = true) Integer systemId,
                                                @RequestParam(value = "userId", required = true) Integer userId);

}