/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.acl.facade;

import com.bxm.acl.facade.model.ResultModel;
import com.bxm.acl.facade.model.UserRo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author leon 2018年4月13日 下午4:31:01
 * @ClassName AclAuthorService.java
 * @Description 功能描述：用户权限接口
 * @CopyRight 杭州微财网络科技有限公司
 */
@FeignClient(name = "adsacl")
public interface AclUserService {

    /**
     * @param id
     * @return
     * @Description 方法描述： 根据id查询数据
     * @author leon 2017年9月5日 下午7:35:07
     * @CopyRight 杭州微财网络科技有限公司
     */
    @RequestMapping(value = "/user/getById", method = RequestMethod.GET)
    ResultModel<UserRo> getById(@RequestParam(value = "id", required = true) Integer id);

    /**
     * @return
     * @Description 方法描述： 登录
     * @author leon 2017年9月5日 下午7:21:30
     * @CopyRight 杭州微财网络科技有限公司
     */
    @RequestMapping(value = "/user/login", method = {RequestMethod.POST})
    ResultModel<UserRo> login(@RequestParam(value = "username", required = true) String username,
                              @RequestParam(value = "password", required = true) String password);

    /**
     * @param token
     * @return
     * @Description 方法描述： 根据token查询用户
     * @author leon 2017年10月22日 下午2:14:23
     * @CopyRight 杭州微财网络科技有限公司
     */
    @RequestMapping(value = "/user/getByToken", method = {RequestMethod.GET})
    ResultModel<UserRo> getUserByToken(@RequestParam(value = "token", required = true) String token);

    /**
     * @return
     * @Description 方法描述： 根据username查询用户
     * @author leon 2017年10月22日 下午2:14:23
     * @CopyRight 杭州微财网络科技有限公司
     */
    @RequestMapping(value = "/user/user/getByUsername", method = {RequestMethod.GET})
    ResultModel<UserRo> getUserByUsername(@RequestParam(value = "username") String username);

    /**
     * 根据角色code查询所对应的用户code以及xymy
     *
     * @param roleCode       角色Code
     * @param onlyShowEnable 是否只显示启用账号
     * @return
     */
    @RequestMapping(value = "/user/queryUserByRoleCode", method = RequestMethod.GET)
    ResultModel<Map</*userName*/String, /*name*/String>> queryUserByRoleCode(@RequestParam(value = "roleCode") String roleCode
            , @RequestParam(value = "onlyShowEnable") Boolean onlyShowEnable);


    @RequestMapping(value = "/user/queryAllUser", method = RequestMethod.GET)
    ResultModel<Map<String, String>> queryAllUser();

    /**
     * 根据用户名模糊搜索
     *
     * @param name
     * @return
     */
    @RequestMapping(value = "/user/queryUserNameByName", method = RequestMethod.GET)
    ResultModel<List<String>> queryUserNameByName(@RequestParam(value = "name") String name);


}
