package com.bxm.adapi.dal.ad_api_material.base;

import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.Column;
import java.io.Serializable;

/**
 * 抽象数据库实体<br>
 *
 * @author spider_man
 *
 */
@Getter
@Setter
public abstract class BaseEntity implements Serializable{
	/**
	 *
	 */
	private static final long serialVersionUID = 5519791637940996854L;

	/**
	 * ID
	 */
	@Column
	private Long id;

	/**
	 * 创建日期
	 */
	@Column
	protected String created;

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.SHORT_PREFIX_STYLE);
	}
}
