package com.bxm.adapi.dal.ad_api_material.base;


import org.apache.ibatis.annotations.*;

import java.util.List;

/**
 * Created by spider_man
 */
public interface BaseMapper<T extends BaseEntity> {

    @SelectProvider(type = BaseDaoTemplate.class, method = "countByExample")
    int countByExample(@Param("example") Example<T> example);

    @SelectProvider(type = BaseDaoTemplate.class, method = "countColByExample")
    int countColByExample(@Param("col") String col,
                          @Param("example") Example<T> example);

    @DeleteProvider(type = BaseDaoTemplate.class, method = "deleteByExample")
    int deleteByExample(@Param("example") Example<T> example);

    @DeleteProvider(type = BaseDaoTemplate.class, method = "deleteByPrimaryKey")
    int deleteByPrimaryKey(T entity);

    @InsertProvider(type = BaseDaoTemplate.class, method = "insertSelective")
    @Options(useGeneratedKeys = true, keyProperty = "id", keyColumn = "id")
    int insertSelective(T record);

    @InsertProvider(type = BaseDaoTemplate.class, method = "insert")
    @Options(useGeneratedKeys = true, keyProperty = "id", keyColumn = "id")
    int insertWithNullValue(T record);

    @SelectProvider(type = BaseDaoTemplate.class, method = "selectByExample")
    @ResultMap("ListMap")
    List<T> selectByExample(@Param("example") Example<T> example);


    @SelectProvider(type = BaseDaoTemplate.class, method = "selectByExampleAndPage")
    @ResultMap("ListMap")
    List<T> selectByExampleAndPage(@Param("example") Example<T> examplee, @Param("pageNum") Integer pageNum,
                                   @Param("pageSize") Integer pageSiz);

    @ResultMap("DetailMap")
    T selectByPrimaryKey(Long id);

    @SelectProvider(type = BaseDaoTemplate.class, method = "selectOneByExample")
    @ResultMap("DetailMap")
    T selectOneByExample(@Param("example") Example<T> example);

    @SelectProvider(type = BaseDaoTemplate.class, method = "sumByExample")
    Double sumByExample(@Param("field") String field,
                        @Param("example") Example<T> example);

    @UpdateProvider(type = BaseDaoTemplate.class, method = "updateByExampleSelective")
    int updateByExample(@Param("record") T record,
                        @Param("example") Example<T> example);

    @UpdateProvider(type = BaseDaoTemplate.class, method = "updateByExample")
    int updateByExampleWithNullValue(@Param("record") T record,
                                     @Param("example") Example<T> example);

    @UpdateProvider(type = BaseDaoTemplate.class, method = "updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(T record);

    @UpdateProvider(type = BaseDaoTemplate.class, method = "updateByPrimaryKey")
    int updateByPrimaryKey(T record);

}
