/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adapi.dal.ad_api_material.mapper.ext;

import com.bxm.adapi.dal.ad_api_material.base.BaseMapper;
import com.bxm.adapi.dal.ad_api_material.model.AdapiAdPositionMaterialCtrDo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @ClassName AdapiAdPositionMaterialCtrDoMapperExt.java
 * @Description 功能描述：
 * @author leon 2018年4月2日 上午11:01:36
 * @CopyRight 杭州微财网络科技有限公司
 */
public interface AdapiAdPositionMaterialCtrDoMapperExt extends BaseMapper<AdapiAdPositionMaterialCtrDo> {

    /**
     * @Description 方法描述：根据媒体广告位id和广告位素材id查询列表
     * @author leon 2018年3月31日 下午12:40:57
     * @CopyRight 杭州微财网络科技有限公司
     * @param mediaAdPositionId
     * @param adPositionMaterialId
     * @return
     */
    List<AdapiAdPositionMaterialCtrDo> getListByMediaAdPositionIdAndAdPositionMaterialId(@Param("mediaAdPositionId") Long mediaAdPositionId,
                                                                                         @Param("adPositionMaterialId") Long adPositionMaterialId);

    /**
     * @Description 方法描述：根据媒体广告位id和广告位素材id修改
     * @author leon 2018年3月31日 下午1:24:36
     * @CopyRight 杭州微财网络科技有限公司
     * @param adapiAdPositionMaterialCtrDo
     * @return
     */
    int updateByMediaAdPositionIdAndAdPositionMaterialId(AdapiAdPositionMaterialCtrDo adapiAdPositionMaterialCtrDo);

    /**
     * @Description 方法描述：根据媒体广告位id和广告位素材id删除
     * @author leon 2018年3月31日 下午12:40:57
     * @CopyRight 杭州微财网络科技有限公司
     * @param mediaAdPositionId
     * @param adPositionMaterialId
     * @return
     */
    int deleteByByMediaAdPositionIdAndAdPositionMaterialId(@Param("mediaAdPositionId") Long mediaAdPositionId,
                                                           @Param("adPositionMaterialId") Long adPositionMaterialId);

    Boolean updateCtrInfoOffset(@Param("adMaterialId")Long adMaterialId, @Param("clickOffset") Long clickOffset, @Param("exposureOffset") Long exposureOffset);

    AdapiAdPositionMaterialCtrDo selectByAdMaterialId(@Param("adMaterialId") Long adMaterialId);
}
