package com.bxm.adapi.dal.ad_api_material.model;

import com.bxm.adapi.dal.ad_api_material.base.BaseEntity;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Date;


@Getter
@Setter
@Table(name = "media_ad_position")
public class MediaAdPositionDo extends BaseEntity {

    @Column(name = "ad_position_id")
    private String adPositionId;    // 广告位id(appId+app_entrance_id)

    @Column(name = "ad_position_name")
    private String adPositionName;  // 广告位名称

    @Column(name = "app_name")
    private String appName; // app名称

    @Column(name = "media_type")
    private String mediaType;   // 媒体类型

    @Column(name = "media_class")
    private String mediaClass;  // 媒体分类

    @Column(name = "media_child_class")
    private String mediaChildClass; // 媒体子分类

    @Column(name = "image_size")
    private String imageSize;   // 素材图片尺寸

    @Column(name = "material_num")
    private Integer materialNum;    // 媒体广告位素材数量

    @Column(name = "deleted")
    private Date deleted;   // 删除时间(不为空代表删除）

    @Column(name = "updated")
    private Date updated;   // 修改时间

    @Column(name = "position_type")
    private String positionType;    // 广告位类型,NON_INFORMATION_FLOW:非信息流;INFORMATION_FLOW:信息流

    @Column(name = "dockingMethod")
    private Integer dockingMethod;  // 对接方式：0获取链接,1JS对接,2API对接

    @Column(name = "materialType")
    private String materialType;    // 素材类型

    @Column(name = "historyCtr")
    private Double historyCtr;  // 历史点击率
}