/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.adapi.integration.xunfei;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adapi.model.constant.Constant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

@Service
public class DingtalkMsgService {
    private static final Logger log = LoggerFactory.getLogger(DingtalkMsgService.class);

    @Value("${spring.profiles.active}")
    private String env;

    /**
     * @Description 方法描述：发送钉钉信息
     * @author leon 2018年4月11日 上午10:18:15
     * @CopyRight 杭州微财网络科技有限公司
     * @param content 消息内容
     * @param isAtAll 是否@全部
     * @throws IOException
     */
    public void sendMsg(String content, Boolean isAtAll) {
        try {
            String url = isProd() ? Constant.DINGTALK_WEBHOOK_OPERATE : Constant.DINGTALK_WEBHOOK_TEC_TEST;
            content = prefix() + content;
            JSONObject jsonParam = new JSONObject();
            Map<String, Object> text = new HashMap<String, Object>();
            text.put("content", content);

            Map<String, Object> at = new HashMap<String, Object>();
            if (isProd()) {
                at.put("atMobiles", Constant.DINGTALK_WEBHOOK_AT_OPERATE_USER_LIST);
                at.put("isAtAll", isAtAll);
            }
            jsonParam.put("msgtype", "text");
            jsonParam.put("text", text);
            jsonParam.put("at", at);

            OkHttpUtils.post(url, jsonParam.toJSONString());
        } catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    /**
     * @Description 方法描述：发送钉钉信息
     * @author leon 2018年4月11日 上午10:18:15
     * @CopyRight 杭州微财网络科技有限公司
     * @param isAtAll 是否@全部
     * @param exception 异常
     * @throws IOException
     */
    public void sendErrorMsg(String contentTitle, Boolean isAtAll, Exception exception) {
        try {
            String url = isProd() ? Constant.DINGTALK_WEBHOOK_OPERATE : Constant.DINGTALK_WEBHOOK_TEC_TEST;
            JSONObject jsonParam = new JSONObject();

            // 追加消息打印相关堆栈信息
            StringBuilder content = new StringBuilder(prefix() + contentTitle + "\n");
            StringWriter sw = new StringWriter();
            exception.printStackTrace(new PrintWriter(sw, true));
            content.append(sw.toString());

            Map<String, Object> text = new HashMap<String, Object>();
            text.put("content", content.toString());

            Map<String, Object> at = new HashMap<String, Object>();
            if (isProd()) {
                at.put("atMobiles", Constant.DINGTALK_WEBHOOK_AT_TEC_USER_LIST);
                at.put("isAtAll", isAtAll);
            }
            jsonParam.put("msgtype", "text");
            jsonParam.put("text", text);
            jsonParam.put("at", at);

            OkHttpUtils.post(url, jsonParam.toJSONString());
        } catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    private String prefix(){
        if ("dev".equals(env)){
            return "[开发环境]";
        }
        if("test".equals(env)) {
            return "[测试环境]";
        }
        return "[生产环境]";
    }

    private boolean isProd(){
        return !"dev".equals(env) && !"test".equals(env);
    }

}
