/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered Stringo with bianxianmao.com.
 */
package com.bxm.adapi.integration.xunfei;

import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName InputTypeEnum.java
 * @Description 功能描述：素材输入类型枚举
 * @author leon 2018年4月20日 上午9:36:05
 * @CopyRight 杭州微财网络科技有限公司
 */
public enum InputTypeEnum {
                           /**
                            * 图片
                            */
                           PICTURE("picture", "图片"),
                           /**
                            * 文字
                            */
                           text("text", "文字");

    private String code;

    private String name;

    /**
     * @param code
     * @param name
     */
    private InputTypeEnum(String code, String name){
        this.code = code;
        this.name = name;
    }

    /**
     * @return the code
     */
    public String getCode() {
        return code;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * 所有状态
     * 
     * @return
     */
    public static Map<String, String> getAllState() {
        InputTypeEnum[] sts = InputTypeEnum.values();
        Map<String, String> maps = new HashMap<String, String>();
        for (InputTypeEnum tmp : sts) {
            maps.put(tmp.code, tmp.name);
        }
        return maps;
    }

    /**
     * 根据code得到name
     * 
     * @param code
     * @return
     */
    public static String getName(String code) {
        for (InputTypeEnum state : InputTypeEnum.values()) {
            if (state.getCode() == code) {
                return state.getName();
            }
        }
        return "状态异常";
    }

}
