package com.bxm.adsalgorithm.facade.model;

import lombok.Data;

import java.io.Serializable;
import java.math.BigInteger;

/**
 * @author daill
 * @date 2021-03-29
 */
@Data
public class TicketAssetsFeatureDto implements Serializable {
    private static final long serialVersionUID = 4368329874118574L;

    private BigInteger id; //f9001
    /**
     * 0.横版大图600*300(默认值，原不限弹窗)
     * 1.竖版大图（原一体化弹窗）
     * 2.横版大图1280*720
     * 3.竖版大图1080*1920
     * 4.小图150*150
     * 5.竖版大图-动画素材
     */
    private String isShieldPopup; //f9002

    /**
     * 上一次的素材id，素材尺寸
     */
    private BigInteger beforeId;    //f9006
    private String beforeIsShieldPopup; //f9003


    //当前素材第几次发（用户维度,当天）
    private Long userOneDayAssetIdUserIdRank;   //f9004

    //当前素材第几次发（用户维度，全局）
    private Long userCurrentAssetIdUserIdRank; //f9005

    //当前素材上一次是否计费
    private Long assetIdLastChargeNums; //f9007

    //广告位-广告-活动-素材 ctr cvr（2个特征）
    private Double positionTicketActivityAssetIdCVR;//9013
    private Double positionTicketActivityAssetIdCTR;//f9009

    //广告位-广告-素材 ctr cvr（2个特征）
    private Double positionTicketAssetIdCVR;//9014
    private Double positionTicketAssetIdCTR; //f9010
    //广告-活动-素材 ctr cvr（2个特征）
    private Double TicketActivityAssetIdCVR;//9015
    private Double TicketActivityAssetIdCTR; //9011

    //广告-素材 ctr cvr（2个特征）
    private Double TicketAssetIdCVR;  //f9012
    private Double TicketAssetIdCTR; //f9008
}
