package com.bxm.counter.facade.ticket;

import com.bxm.warcar.validate.annotation.DefaultValue;
import com.bxm.warcar.validate.annotation.ValidateImeiOrIdfa;
import com.bxm.warcar.validate.annotation.ValidateLength;
import com.bxm.warcar.validate.annotation.ValidateNotNull;

import java.io.Serializable;

/**
 * <p> countInfo接口参数类 </p>
 * @Author: JandMin
 * @Date: 2018/7/20
 */
public class TicketCountMsgDto implements Serializable{
    private static final long serialVersionUID = -537631479506482834L;
    /**
     * 用户IP
     */
    private String ipAddress;

    /**
     * 商家标志
     */
    @ValidateNotNull
    @DefaultValue("mistake_appKey")
    @ValidateLength(min = 32,max = 32)
    private String appkey;

    /**
     * 业务类型
     */
    @ValidateNotNull
    @DefaultValue("money")
    private String business;

    /**
     * 流水号(modelName)
     */
    private String spm;

    /**
     * Andriod IMEI(imei)
     */
    @ValidateImeiOrIdfa
    private String i;

    /**
     * IOS IDFA
     */
    @ValidateImeiOrIdfa
    private String f;

    /**
     * 用户token
     */
    @ValidateNotNull
    @DefaultValue("mistake_uid")
    private String uid;

    /**
     * 设备类型:1 Android;2 IOS;3 web
     */
    @ValidateNotNull
    @DefaultValue("-1")
    private Integer appos;

    /**
     * 活动ID
     */
    @ValidateNotNull
    @DefaultValue("0")
    private Long activityid;

    /**
     * 模块类型modelType
     */
    @ValidateNotNull
    @DefaultValue("90")
    private Integer modeltype;

    /**
     * 奖品类型awardType
     */
    private Integer awardtype;

    /**
     * 奖品ID(旧名:ticketId)
     */
    @ValidateNotNull
    @DefaultValue("0")
    private Long preid;

    /**
     * 说明
     */
    private String remark;

    /**
     * 客户端标识:1 微信; 2 支付宝;0 其它
     */
    private String ua;

    /**
     * 弹窗类型：0 活动出券;1 首页弹窗;2 挽留弹窗
     */
    @ValidateNotNull
    @DefaultValue("0")
    private Integer scene;

    /**
     * 是否阿里支付isAli:1 是, 0 否
     */
    private String isali;

    /**
     * 当前点击位置：当前点击X轴
     */
    private String random1;

    /**
     * 当前点击位置：当前点击y轴
     */
    private String random2;

    /**
     * 设置宽高，用于统计
     */
    private String random3;

    /**
     * 弹窗ID
     */
    private String popupId;

    /**
     * 素材ID
     */
    private String assetsId;

    /**
     * 请求Header内容
     */
    private String origin;

    /**
     * 本次点击实际出价
     */
    private Integer offerPrice;

    /**
     * 统计的唯一标识：如果billid为null则为uuid
     */
    private String countId;

    /**
     * 签名手否正确
     */
    private String remark3;

    /**
     * 是否直投 1：直投  0或者空：非直投
     */
    private Integer direct;
    /**
     *  预留字段ext
     */
    private String ext;

    public String getExt() {
        return ext;
    }

    public void setExt(String ext) {
        this.ext = ext;
    }

    public String getIpAddress() {
        return ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getAppkey() {
        return appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public String getSpm() {
        return spm;
    }

    public void setSpm(String spm) {
        this.spm = spm;
    }

    public String getI() {
        return i;
    }

    public void setI(String i) {
        this.i = i;
    }

    public String getF() {
        return f;
    }

    public void setF(String f) {
        this.f = f;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public Integer getAppos() {
        return appos;
    }

    public void setAppos(Integer appos) {
        this.appos = appos;
    }

    public Long getActivityid() {
        return activityid;
    }

    public void setActivityid(Long activityid) {
        this.activityid = activityid;
    }

    public Integer getModeltype() {
        return modeltype;
    }

    public void setModeltype(Integer modeltype) {
        this.modeltype = modeltype;
    }

    public Integer getAwardtype() {
        return awardtype;
    }

    public void setAwardtype(Integer awardtype) {
        this.awardtype = awardtype;
    }

    public Long getPreid() {
        return preid;
    }

    public void setPreid(Long preid) {
        this.preid = preid;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getUa() {
        return ua;
    }

    public void setUa(String ua) {
        this.ua = ua;
    }

    public Integer getScene() {
        return scene;
    }

    public void setScene(Integer scene) {
        this.scene = scene;
    }

    public String getIsali() {
        return isali;
    }

    public void setIsali(String isali) {
        this.isali = isali;
    }

    public String getRandom1() {
        return random1;
    }

    public void setRandom1(String random1) {
        this.random1 = random1;
    }

    public String getRandom2() {
        return random2;
    }

    public void setRandom2(String random2) {
        this.random2 = random2;
    }

    public String getRandom3() {
        return random3;
    }

    public void setRandom3(String random3) {
        this.random3 = random3;
    }

    public String getPopupId() {
        return popupId;
    }

    public void setPopupId(String popupId) {
        this.popupId = popupId;
    }

    public String getAssetsId() {
        return assetsId;
    }

    public void setAssetsId(String assetsId) {
        this.assetsId = assetsId;
    }

    public String getOrigin() {
        return origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public Integer getOfferPrice() {
        return offerPrice;
    }

    public void setOfferPrice(Integer offerPrice) {
        this.offerPrice = offerPrice;
    }

    public String getCountId() {
        return countId;
    }

    public void setCountId(String countId) {
        this.countId = countId;
    }

    public String getRemark3() {
        return remark3;
    }

    public void setRemark3(String remark3) {
        this.remark3 = remark3;
    }

    public Integer getDirect() {
        return direct;
    }

    public void setDirect(Integer direct) {
        this.direct = direct;
    }
}
