package com.bxm.counter.facade.ticket;

import com.bxm.counter.facade.TicketCounterConstants;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * <p> 广告券相关统计接口 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/7/25
 */
@FeignClient(name = TicketCounterConstants.SERVER_NAME)
public interface TicketCounterService {

    /**
     * 保存广告券统计数据
     * @date: 2018/7/25
     * @param request
     * @return java.lang.String
     */
    @RequestMapping(value = "/ticketCounterService/saveTicketCountMsg", method = RequestMethod.POST)
    TicketMsgDto saveTicketCountMsg2(@RequestBody TicketCounterRequest request) throws NoStatisticsException;

    /**
     * 保存广告组统计数据
     * @date: 2018/8/9
     * @param adGroupMsg
     * @return void
     * @throws
     */
    @RequestMapping(value = "/ticketCounterService/saveGroupCountMsg", method = RequestMethod.POST)
    void saveGroupCountMsg(@RequestBody AdGroupCountMsg adGroupMsg) throws Exception;
}
