package com.bxm.adscounter.openlog;

import com.bxm.adscounter.openlog.autoconfigure.Properties;
import com.bxm.openlog.sdk.listener.eventbus.EnableOpenLogEventBusFactory;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.EnableFeignClients;

/**
 * @author yirenjie
 * createDate:  2019/3/29
 */
@SpringBootApplication(scanBasePackages = {
        "com.bxm.adscounter.openlog",
        "com.bxm.adscounter.rtb.common",
        "com.bxm.adscounter.integration"
})
@MapperScan("com.bxm.adscounter.rtb.common.mapper")
@EnableFeignClients(basePackages = {"com.bxm.adsprod.facade"})
@EnableOpenLogEventBusFactory
@EnableConfigurationProperties({
        Properties.class
})
public class AdscounterOpenlogApplication {

    public static void main(String[] args) {
        SpringApplication.run(AdscounterOpenlogApplication.class, args);
    }
}
