package com.bxm.adscounter.openlog.autoconfigure;

import com.bxm.openlog.extension.client.HttpClientOpenLogClient;
import com.bxm.openlog.extension.client.OpenLogClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @date 2023-03-03
 * @since 1.0
 */
@Configuration
public class OpenLogClientAutoConfiguration {

    private final Properties properties;

    public OpenLogClientAutoConfiguration(Properties properties) {
        this.properties = properties;
    }

    @Bean
    public OpenLogClient openLogClient() {
        return HttpClientOpenLogClient.builder()
                .setMaxTotal(properties.getMaxTotal())
                .setDefaultMaxPerRoute(properties.getDefaultMaxPerRoute())
                .setConnectionRequestTimeout(properties.getConnectionRequestTimeout())
                .setConnectTimeout(properties.getConnectTimeout())
                .setSocketTimeout(properties.getSocketTimeout())
                .build();
    }
}
