package com.bxm.adscounter.openlog.autoconfigure;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @date 2019/3/8
 * @since 1.0.0
 */
@ConfigurationProperties(prefix = "openlog")
@Data
public class Properties {

    /**
     * 消费组核心名称
     */
    @Value("${openlog.consumer-id:${spring.application.name}}")
    private String consumerId;

    /**
     * OpenLog 内网请求地址
     */
    private String openLogRequestDomain = "http://openlog.bianxianmao.com";
    /**
     * OpenLog 外网请求地址
     */
    private String openLogRequestOutDomain = "https://openlog.hzbxm.com";

    private int maxTotal = 500;
    private int defaultMaxPerRoute = 500;
    private int connectionRequestTimeout = 100;
    private int connectTimeout = 200;
    private int socketTimeout = 500;
}
