package com.bxm.adscounter.openlog.autoconfigure.algoredis;

import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;


/**
 * @author allen
 * @since 1.0.0
 */
@Configuration
@EnableConfigurationProperties(AlgoRedisProperties.class)
public class AlgoRedisConfiguration {

    private final AlgoRedisProperties newRedisConfiguration;

    public AlgoRedisConfiguration(AlgoRedisProperties newRedisConfiguration) {
        this.newRedisConfiguration = newRedisConfiguration;
    }

    @Bean
    public JedisPool jedisPoolForAlgo() {
        return new JedisPool(newRedisConfiguration, newRedisConfiguration.getHost(), newRedisConfiguration.getPort(), newRedisConfiguration.getTimeout(),
                newRedisConfiguration.getPassword(), newRedisConfiguration.getDatabase());
    }


    @Bean
    public JedisUpdater jedisUpdaterForAlgo() {
        return new JedisUpdater(jedisPoolForAlgo());
    }


}

