package com.bxm.adscounter.openlog.autoconfigure.reporting;

import com.aliyun.openservices.aliyun.log.producer.ProducerConfig;
import com.aliyun.openservices.aliyun.log.producer.ProjectConfig;
import com.bxm.warcar.logging.extension.AliyunLogServiceCustomLoggingWriter;
import com.bxm.warcar.logging.extension.CustomLoggingWriter;
import com.bxm.warcar.utils.NamedThreadFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author allen
 * @date 2022-05-30
 * @since 1.0
 */
@Configuration
@EnableConfigurationProperties(SlsProperties.class)
public class ReportingAutoConfiguration {

    private final SlsProperties properties;

    public ReportingAutoConfiguration(SlsProperties properties) {
        this.properties = properties;
    }

    @Bean(name = "customLoggingWriterForAdClickReporting")
    public CustomLoggingWriter customLoggingWriterForAdClickReporting() {
        return createCustomLoggingWriter(properties.getLogStoreForAdClickReporting());
    }

    @Bean(name = "customLoggingWriterForRtbFeedback")
    public CustomLoggingWriter customLoggingWriterForRtbFeedback() {
        return createCustomLoggingWriter(properties.getLogStoreForRtbFeedback());
    }

    @Bean(name = "customLoggingWriterForOcpxClickReporting")
    public CustomLoggingWriter customLoggingWriterForOcpxClickReporting() {
        return createCustomLoggingWriter(properties.getLogStoreForOcpxClickReporting());
    }

    private CustomLoggingWriter createCustomLoggingWriter(String logStore) {
        ProducerConfig producerConfig = new ProducerConfig();
        ProjectConfig projectConfig = new ProjectConfig(properties.getProject(), properties.getEndpoint(),
                properties.getAccessKeyId(), properties.getAccessKeySecret());
        AliyunLogServiceCustomLoggingWriter writer = new AliyunLogServiceCustomLoggingWriter(producerConfig, projectConfig, logStore);
        if (properties.isEnableThreadPool()) {
            int coreSize = properties.getCoreSize();
            ThreadPoolExecutor executor = new ThreadPoolExecutor(coreSize, coreSize, 0,
                    TimeUnit.MILLISECONDS, new LinkedBlockingQueue<>(500),
                    new NamedThreadFactory("sls-writer"));
            writer.setExecutor(executor);
        }
        return writer;
    }
}
