package com.bxm.adscounter.openlog.consumer.common;

import com.bxm.adscounter.openlog.autoconfigure.Properties;
import com.bxm.adscounter.openlog.consumer.common.event.DhhConversionEvent;
import com.bxm.adscounter.openlog.consumer.common.event.OceanengineClickMonitorEvent;
import com.bxm.adscounter.openlog.consumer.common.event.OcpxReportingEvent;
import com.bxm.adscounter.openlog.consumer.common.event.RtbConversionEvent;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.openlog.sdk.listener.eventbus.OpenLogEventBusBean;
import com.bxm.openlog.sdk.listener.eventbus.OpenLogEventConfig;
import com.bxm.warcar.integration.eventbus.EventPark;
import org.springframework.context.annotation.Configuration;

import java.util.Collection;

/**
 * @author allen
 * @date 2022-02-16
 * @since 1.0
 */
@Configuration
public class DefaultOpenLogEventBusBean implements OpenLogEventBusBean {

    private final EventPark eventPark;

    private final Properties properties;

    public DefaultOpenLogEventBusBean(EventPark eventPark, Properties properties) {
        this.eventPark = eventPark;
        this.properties = properties;
    }

    @Override
    public String getId() {
        return properties.getConsumerId().toUpperCase();
    }

    @Override
    public Production getProduction() {
        return Production.COMMON;
    }

    @Override
    public EventPark getEventPark() {
        return eventPark;
    }

    @Override
    public void bindTo(Collection<OpenLogEventConfig> registry) {
        registry.add(OpenLogEventConfig.builder().mt(Common.Mt.oCpx_Reporting.original()).eventType(OcpxReportingEvent.class).build());
        registry.add(OpenLogEventConfig.builder().mt(Common.Mt.rtbConversion.original()).eventType(RtbConversionEvent.class).build());
        registry.add(OpenLogEventConfig.builder().mt(Common.Mt.OceanengineClickTracker.original()).eventType(OceanengineClickMonitorEvent.class).build());
        registry.add(OpenLogEventConfig.builder().mt(Common.Mt.DhhConversion.original()).eventType(DhhConversionEvent.class).build());
    }
}
