package com.bxm.adscounter.openlog.consumer.common.listener;

import com.bxm.adscounter.integration.taobao.TaobaoIntegration;
import com.bxm.adscounter.integration.taobao.TaobaoProperties;
import com.bxm.adscounter.integration.taobao.TaobaoRequest;
import com.bxm.adscounter.openlog.autoconfigure.Properties;
import com.bxm.adscounter.openlog.consumer.common.event.OceanengineClickMonitorEvent;
import com.bxm.adscounter.openlog.utils.UrlHelper;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.TypeHelper;
import org.springframework.context.annotation.Configuration;

/**
 * 巨量引擎点击监测上报给大航海（淘宝）oCPX
 *
 * @author allen
 * @date 2022-04-28
 * @since 1.0
 */
@Configuration
public class OceanengineClickEventListener implements EventListener<OceanengineClickMonitorEvent> {

    private final Properties properties;
    private final TaobaoIntegration taobaoIntegration;
    private final TaobaoProperties taobaoProperties;

    public OceanengineClickEventListener(Properties properties, TaobaoIntegration taobaoIntegration, TaobaoProperties taobaoProperties) {
        this.properties = properties;
        this.taobaoIntegration = taobaoIntegration;
        this.taobaoProperties = taobaoProperties;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(OceanengineClickMonitorEvent event) {
        KeyValueMap m = event.getLog();

        String imei = m.getFirst("imei");
        String oaid = m.getFirst("oaid");
        String oaidMd5 = m.getFirst("oaid_md5");
        String androidid = m.getFirst("androidid");
        String idfa = m.getFirst("idfa");
        String clickId = m.getFirst("click_id");
        String app = m.getFirst("app");
        String taskId = m.getFirst("taskId");
        String channel = m.getFirst("channel");
        String advertisingSpaceId = m.getFirst("advertisingSpaceId");
        String adid = m.getFirst("adid");
        String cid = m.getFirst("cid");
        String adAgent = m.getFirst("adAgent");
        String convDef = m.getFirst("conv_def");

        TaobaoRequest request = new TaobaoRequest();
        request.setReportUrl(taobaoProperties.getReportClickUrl())
                .setTaskId(taskId)
                .setApp(app)
                .setChannel(channel)
                .setAdid(adid)
                .setCid(cid)
                .setAdAgent(adAgent)
                .setAdvertisingSpaceId(advertisingSpaceId)
                .setImei(imei)
                .setOaid(oaid)
                .setOaidMd5(oaidMd5)
                .setIdfa(idfa)
                .setCallbackUrl(UrlHelper.urlEncode(getFeedbackUrl(clickId, convDef)))
                .setTimestamp(TypeHelper.castToString(System.currentTimeMillis()));

        taobaoIntegration.report(request);
    }

    private String getFeedbackUrl(String clickId, String convDef) {
        KeyValueMap map = new KeyValueMap();
        map.setProduction(Production.COMMON);
        map.setMt(Common.Mt.DhhConversion.original());
        map.putIfNotBlank("click_id", clickId);
        map.putIfNotBlank("conv_def", convDef);
        return map.createOpenLogRequestUri(properties.getOpenLogRequestOutDomain());
    }
}
