package com.bxm.adscounter.openlog.consumer.pangu.listener;

import com.bxm.adscounter.model.constant.Constants;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.openlog.sdk.consts.Pangu;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;

/**
 * @author allen
 * @date 2022-05-09
 * @since 1.0
 */
final class Convert2 {

    private Convert2() {}

    static KeyValueMap convert2InadsLog(KeyValueMap panguLog, String mt) {
        KeyValueMap inadsLog = new KeyValueMap();
        inadsLog.setProduction(Production.INADS);
        inadsLog.setMt(mt);
        inadsLog.setIp(panguLog.getIp());
        inadsLog.setUa(panguLog.getUa());
        inadsLog.setRef(panguLog.getRef());
        inadsLog.putIfNotBlank(Inads.Param.BXMID, panguLog.getFirst(Pangu.Param.BXMID));
        inadsLog.putIfNotBlank(Inads.Param.UID, panguLog.getFirst(Pangu.Param.UID));
        inadsLog.putIfNotBlank(Inads.Param.TIME, panguLog.getFirst(Pangu.Param.TIME));
        inadsLog.putIfNotBlank(Inads.Param.BIDID, panguLog.getFirst(Pangu.Param.BIDID));
        inadsLog.putIfNotBlank(Inads.Param.OBIDID, panguLog.getFirst(Pangu.Param.OBIDID));
        inadsLog.putIfNotBlank(Inads.Param.ADID, panguLog.getFirst(Pangu.Param.ADID));
        inadsLog.putIfNotBlank(Inads.Param.TAGID, panguLog.getFirst(Pangu.Param.TAGID));
        inadsLog.putIfNotBlank(Inads.Param.DEVICE, panguLog.getFirst(Pangu.Param.DEVICE));
        inadsLog.putIfNotBlank(Inads.Param.CALLBACK, panguLog.getFirst(Pangu.Param.CALLBACK));

        String panguOs = panguLog.getFirst(Pangu.Param.OS);
        if (StringUtils.isNotBlank(panguOs)) {
            switch (panguOs.toLowerCase()) {
                case "android":
                    inadsLog.put(Inads.Param.OS, "1");
                    break;
                case "ios":
                    inadsLog.put(Inads.Param.OS, "2");
                    break;
                default:
                    inadsLog.put(Inads.Param.OS, "3");
            }
        }
        inadsLog.putIfNotBlank(Inads.Param.DEVICE, panguLog.getFirst(Pangu.Param.DEVICE));
        inadsLog.putIfNotBlank(Inads.Param.SPM, panguLog.getFirst(Pangu.Param.BIDID));
        inadsLog.putIfNotBlank(Inads.Param.CREATEID, panguLog.getFirst(Pangu.Param.CREATEID));
        inadsLog.putIfNotBlank(Inads.Param.ACTYPE, panguLog.getFirst(Pangu.Param.ADCT));
        inadsLog.putIfNotBlank(Inads.Param.SRC_TYPE, (StringUtils.equals("13", panguLog.getFirst(Pangu.Param.ADCT))) ? "1" : "0");
        inadsLog.putIfNotBlank(Inads.Param.EN_ADID, panguLog.getFirst(Pangu.Param.ADID));
        inadsLog.putIfNotBlank(Inads.Param.EN_CID, panguLog.getFirst(Pangu.Param.CREATEID));
        inadsLog.putIfNotBlank(Inads.Param.ADX_APPID, panguLog.getFirst(Pangu.Param.ADXAPPID));
        inadsLog.putIfNotBlank(Inads.Param.PICID, panguLog.getFirst(Pangu.Param.PICID));
        inadsLog.putIfNotBlank(Inads.Param.ADVER_OFFER_PRICE, panguLog.getFirst(Pangu.Param.ADVER_OFFER_PRICE));
        inadsLog.putIfNotBlank(Inads.Param.BUNDLE, panguLog.getFirst(Pangu.Param.BUNDLE));

        Map<String, String> ext = Maps.newHashMap();
        String bundle = panguLog.getFirst(Pangu.Param.BUNDLE);
        if(StringUtils.isNotBlank(bundle)){
            ext.put(Constants.PanGu.EXT_APP_BUNDLE, bundle);
        }
        String adxid = panguLog.getFirst(Pangu.Param.ADXID);
        if(StringUtils.isNotBlank(adxid)){
            ext.put(Constants.PanGu.EXT_ADX_ID, adxid);
        }
        String appct = panguLog.getFirst(Pangu.Param.APPCT);
        if(StringUtils.isNotBlank(appct)){
            ext.put(Constants.PanGu.EXT_APP_CAGY, appct);
        }
        String adxtagid = panguLog.getFirst(Pangu.Param.ADX_TAG_ID);
        if(StringUtils.isNotBlank(appct)){
            ext.put(Constants.PanGu.EXT_ADX_TAG_ID, adxtagid);
        }
        String floor = panguLog.getFirst(Pangu.Param.FLOOR);
        if(StringUtils.isNotBlank(appct)){
            ext.put(Constants.PanGu.EXT_FLOOR, floor);
        }

        inadsLog.put(Inads.Param.EXT, JsonHelper.convert(ext));
        inadsLog.put(Inads.Param.SBID,panguLog.getFirst(Inads.Param.SBID));
        return inadsLog;
    }
}
