package com.bxm.adscounter.openlog.consumer.pangu.listener;

import com.bxm.adscounter.openlog.autoconfigure.Properties;
import com.bxm.adscounter.openlog.consumer.pangu.event.PanguAdClickEvent;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * 盘古的广告点击事件 复制到 互动广告的广告点击事件。
 *
 * @author allen
 * @date 2021-11-03
 * @since 1.0
 */
@Slf4j
@Configuration
public class PanguAdClick2InadsEventListener implements EventListener<PanguAdClickEvent> {

    private final Properties properties;
    private final OpenLogClient openLogClient;

    public PanguAdClick2InadsEventListener(Properties properties, OpenLogClient openLogClient) {
        this.properties = properties;
        this.openLogClient = openLogClient;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(PanguAdClickEvent event) {
        KeyValueMap keyValueMap = event.getLog();
        KeyValueMap click = Convert2.convert2InadsLog(keyValueMap, Inads.Mt.AdClick.original());
        try {
            openLogClient.request(click.createOpenLogRequestUri(properties.getOpenLogRequestDomain()));
        } catch (Exception e) {
            log.error("PanguAdClick2InadsEventListener send openLog exception : ",e);
        }
    }
}
