package com.bxm.adscounter.openlog.consumer.pangu.listener;

import com.bxm.adscounter.openlog.autoconfigure.Properties;
import com.bxm.adscounter.openlog.consumer.pangu.event.PanguAdShowEvent;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * 盘古的广告展示事件 复制到 互动广告的广告展示事件。
 *
 * @author allen
 * @date 2021-11-03
 * @since 1.0
 */
@Slf4j
@Configuration
public class PanguAdShow2InadsEventListener implements EventListener<PanguAdShowEvent> {

    private final Properties properties;
    private final OpenLogClient openLogClient;

    public PanguAdShow2InadsEventListener(Properties properties, OpenLogClient openLogClient) {
        this.properties = properties;
        this.openLogClient = openLogClient;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(PanguAdShowEvent event) {
        KeyValueMap keyValueMap = event.getLog();

        KeyValueMap req = Convert2.convert2InadsLog(keyValueMap, Inads.Mt.AdRequest.original());
        try {
            openLogClient.request(req.createOpenLogRequestUri(properties.getOpenLogRequestDomain()));
        } catch (Exception e) {
            log.error("PanguAdShow2InadsEventListener send openLog exception :",e);
        }

        KeyValueMap show = Convert2.convert2InadsLog(keyValueMap, Inads.Mt.AdShow.original());
        try {
            openLogClient.request(show.createOpenLogRequestUri(properties.getOpenLogRequestDomain()));
        } catch (Exception e) {
            log.error("PanguAdShow2InadsEventListener send openLog exception :",e);
        }
    }
}
