package com.bxm.adscounter.controller;

import com.bxm.adscounter.service.reporting.ReportingConfig;
import com.bxm.adscounter.service.reporting.ReportingConfigurer;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @author allen
 * @date 2022-06-10
 * @since 1.0
 */
@RestController
@RequestMapping("/reporting")
public class ReportingConfigController {

    private final ReportingConfigurer configurer;

    public ReportingConfigController(ReportingConfigurer configurer) {
        this.configurer = configurer;
    }

    @GetMapping("/get/{adid}")
    public ResponseEntity<ReportingConfig> get(@PathVariable("adid") String adid) {
        return ResponseEntity.ok(configurer.get(adid));
    }

    @PutMapping("/set/{adid}")
    public ResponseEntity<ReportingConfig> set(@PathVariable("adid") String adid,
                                      @RequestBody ReportingConfig config) {
        configurer.set(adid, config);
        return ResponseEntity.ok(configurer.get(adid));
    }

    @GetMapping("/getAll")
    public ResponseEntity<Map<String, ReportingConfig>> getAll() {
        return ResponseEntity.ok(configurer.getAll());
    }
}
